/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.MathUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookkeeperInternalCallbacks {
    static final Logger LOG = LoggerFactory.getLogger(BookkeeperInternalCallbacks.class);

    public static <T> void finish(int rc, T result, CompletableFuture<? super T> future) {
        if (rc != 0) {
            future.completeExceptionally(BKException.create(rc).fillInStackTrace());
        } else {
            future.complete(result);
        }
    }

    public static interface Processor<T> {
        public void process(T var1, AsyncCallback.VoidCallback var2);
    }

    public static class MultiCallback
    implements AsyncCallback.VoidCallback {
        final int expected;
        final int failureRc;
        final int successRc;
        final AsyncCallback.VoidCallback cb;
        final Object context;
        final ExecutorService callbackExecutor;
        final AtomicInteger done = new AtomicInteger();
        final LinkedBlockingQueue<Integer> exceptions = new LinkedBlockingQueue();

        public MultiCallback(int expected, AsyncCallback.VoidCallback cb, Object context, int successRc, int failureRc) {
            this(expected, cb, context, successRc, failureRc, null);
        }

        public MultiCallback(int expected, AsyncCallback.VoidCallback cb, Object context, int successRc, int failureRc, ExecutorService callbackExecutor) {
            this.expected = expected;
            this.cb = cb;
            this.context = context;
            this.failureRc = failureRc;
            this.successRc = successRc;
            this.callbackExecutor = callbackExecutor;
            if (expected == 0) {
                this.callback();
            }
        }

        private void tick() {
            if (this.done.incrementAndGet() == this.expected) {
                this.callback();
            }
        }

        private void callback() {
            if (null != this.callbackExecutor) {
                try {
                    this.callbackExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            this.doCallback();
                        }
                    });
                }
                catch (RejectedExecutionException ree) {
                    this.doCallback();
                }
            } else {
                this.doCallback();
            }
        }

        private void doCallback() {
            if (this.exceptions.isEmpty()) {
                this.cb.processResult(this.successRc, null, this.context);
            } else {
                this.cb.processResult(this.failureRc, null, this.context);
            }
        }

        @Override
        public void processResult(int rc, String path, Object ctx) {
            if (rc != this.successRc) {
                LOG.error("Error in multi callback : " + rc);
                this.exceptions.add(rc);
            }
            this.tick();
        }
    }

    public static interface GetBookieInfoCallback {
        public void getBookieInfoComplete(int var1, BookieInfoReader.BookieInfo var2, Object var3);
    }

    public static interface ReadEntryListener {
        public void onEntryComplete(int var1, LedgerHandle var2, LedgerEntry var3, Object var4);
    }

    public static interface ReadEntryCallback {
        public void readEntryComplete(int var1, long var2, long var4, ByteBuf var6, Object var7);
    }

    public static interface ReadEntryCallbackCtx {
        public void setLastAddConfirmed(long var1);

        public long getLastAddConfirmed();
    }

    public static class GenericCallbackFuture<T>
    extends CompletableFuture<T>
    implements GenericCallback<T> {
        @Override
        public void operationComplete(int rc, T value) {
            if (rc != 0) {
                this.completeExceptionally(BKException.create(rc));
            } else {
                this.complete(value);
            }
        }
    }

    public static class TimedGenericCallback<T>
    implements GenericCallback<T> {
        final GenericCallback<T> cb;
        final int successRc;
        final OpStatsLogger statsLogger;
        final long startTime;

        public TimedGenericCallback(GenericCallback<T> cb, int successRc, OpStatsLogger statsLogger) {
            this.cb = cb;
            this.successRc = successRc;
            this.statsLogger = statsLogger;
            this.startTime = MathUtils.nowInNano();
        }

        @Override
        public void operationComplete(int rc, T result) {
            if (this.successRc == rc) {
                this.statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
            } else {
                this.statsLogger.registerFailedEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
            }
            this.cb.operationComplete(rc, result);
        }
    }

    public static interface GenericCallback<T> {
        public void operationComplete(int var1, T var2);
    }

    public static class FutureGetListOfEntriesOfLedger
    extends CompletableFuture<AvailabilityOfEntriesOfLedger>
    implements GetListOfEntriesOfLedgerCallback {
        private final long ledgerIdOfTheRequest;

        FutureGetListOfEntriesOfLedger(long ledgerId) {
            this.ledgerIdOfTheRequest = ledgerId;
        }

        @Override
        public void getListOfEntriesOfLedgerComplete(int rc, long ledgerIdOfTheResponse, AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger) {
            if (rc == 0 && this.ledgerIdOfTheRequest != ledgerIdOfTheResponse) {
                LOG.error("For getListOfEntriesOfLedger expected ledgerId in the response: {} actual ledgerId: {}", (Object)this.ledgerIdOfTheRequest, (Object)ledgerIdOfTheResponse);
                rc = -1;
            }
            BookkeeperInternalCallbacks.finish(rc, availabilityOfEntriesOfLedger, this);
        }
    }

    public static interface GetListOfEntriesOfLedgerCallback {
        public void getListOfEntriesOfLedgerComplete(int var1, long var2, AvailabilityOfEntriesOfLedger var4);
    }

    public static interface StartTLSCallback {
        public void startTLSComplete(int var1, Object var2);
    }

    public static interface ForceLedgerCallback {
        public void forceLedgerComplete(int var1, long var2, BookieId var4, Object var5);
    }

    public static interface WriteLacCallback {
        public void writeLacComplete(int var1, long var2, BookieId var4, Object var5);
    }

    public static interface ReadLacCallback {
        public void readLacComplete(int var1, long var2, ByteBuf var4, ByteBuf var5, Object var6);
    }

    public static interface WriteCallback {
        public void writeComplete(int var1, long var2, long var4, BookieId var6, Object var7);
    }

    public static interface LedgerMetadataListener {
        public void onChanged(long var1, Versioned<LedgerMetadata> var3);
    }
}

