/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandStorageService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ExpandStorageService.class);
    protected ServerConfiguration conf;

    public ExpandStorageService(ServerConfiguration conf) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            File[] ledgerDirectories = Bookie.getCurrentDirectories(this.conf.getLedgerDirs());
            File[] journalDirectories = Bookie.getCurrentDirectories(this.conf.getJournalDirs());
            File[] indexDirectories = null == this.conf.getIndexDirs() ? ledgerDirectories : Bookie.getCurrentDirectories(this.conf.getIndexDirs());
            ArrayList<File> allLedgerDirs = Lists.newArrayList();
            allLedgerDirs.addAll(Arrays.asList(ledgerDirectories));
            if (indexDirectories != ledgerDirectories) {
                allLedgerDirs.addAll(Arrays.asList(indexDirectories));
            }
            try (MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(this.conf.getMetadataServiceUri()));){
                driver.initialize(this.conf, () -> {}, NullStatsLogger.INSTANCE);
                Bookie.checkEnvironmentWithStorageExpansion(this.conf, driver, Lists.newArrayList(journalDirectories), allLedgerDirs);
            }
            catch (BookieException e) {
                LOG.error("Exception occurred while updating cookie for storage expansion", (Throwable)e);
                response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
                response.setBody("Exception while updating cookie for storage expansion");
                return response;
            }
            String jsonResponse = "Success expand storage";
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }
}

