/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage;

public final class StorageConstants {
    public static final String CONTROLLER_PATH = "controller";
    public static final String SERVERS_PATH = "servers";
    public static final String CLUSTER_METADATA_PATH = "metadata";
    public static final String CLUSTER_ASSIGNMENT_PATH = "assignment";
    public static final String SEGMENTS_PATH = "segments";
    public static final String STORAGE_PATH = "storage";
    public static final String ZK_METADATA_ROOT_PATH = "/stream";

    private StorageConstants() {
    }

    public static String getControllerPath(String rootPath) {
        return rootPath + "/" + CONTROLLER_PATH;
    }

    public static String getServersPath(String rootPath) {
        return rootPath + "/" + SERVERS_PATH;
    }

    public static String getWritableServersPath(String rootPath) {
        return StorageConstants.getServersPath(rootPath) + "/" + "available";
    }

    public static String getClusterMetadataPath(String rootPath) {
        return rootPath + "/" + CLUSTER_METADATA_PATH;
    }

    public static String getClusterAssignmentPath(String rootPath) {
        return rootPath + "/" + CLUSTER_ASSIGNMENT_PATH;
    }

    public static String getSegmentsRootPath(String rootPath) {
        return rootPath + "/" + SEGMENTS_PATH;
    }

    public static String getStoragePath(String rootPath) {
        return rootPath + "/" + STORAGE_PATH;
    }
}

