/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.shade.org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubTreeCache {
    private static final Logger LOG = LoggerFactory.getLogger(SubTreeCache.class);
    TreeProvider provider;
    Set<Watcher> pendingWatchers = new HashSet<Watcher>();
    Map<String, SubTreeNode> cachedNodes = new HashMap<String, SubTreeNode>();

    public SubTreeCache(TreeProvider provider) {
        this.provider = provider;
    }

    private synchronized void handleEvent(WatchedEvent event) {
        Set<Watcher> toReturn = this.pendingWatchers;
        for (Watcher watcher : this.pendingWatchers) {
            watcher.process(event);
        }
        this.pendingWatchers.clear();
    }

    public synchronized List<String> getChildren(String path) throws KeeperException, InterruptedException {
        SubTreeNode node = this.cachedNodes.get(path);
        if (null == node) {
            node = new SubTreeNode(path);
            node.setChildren(this.provider.getChildren(path, node));
            this.cachedNodes.put(path, node);
        }
        return node.getChildren();
    }

    public synchronized void registerWatcher(Watcher watcher) {
        this.pendingWatchers.add(watcher);
    }

    public synchronized void cancelWatcher(Watcher watcher) {
        this.pendingWatchers.remove(watcher);
    }

    public synchronized WatchGuard registerWatcherWithGuard(Watcher watcher) {
        this.registerWatcher(watcher);
        return new WatchGuard(watcher);
    }

    public class WatchGuard
    implements AutoCloseable {
        final Watcher w;

        WatchGuard(Watcher w) {
            this.w = w;
        }

        @Override
        public void close() {
            SubTreeCache.this.cancelWatcher(this.w);
        }
    }

    private class SubTreeNode
    implements Watcher {
        String path;
        private List<String> children;

        SubTreeNode(String path) {
            this.path = path;
        }

        private void setChildren(List<String> children) {
            this.children = children;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(WatchedEvent event) {
            SubTreeCache subTreeCache = SubTreeCache.this;
            synchronized (subTreeCache) {
                SubTreeCache.this.handleEvent(event);
                SubTreeCache.this.cachedNodes.remove(this.path);
            }
        }

        private List<String> getChildren() {
            return new ArrayList<String>(this.children);
        }
    }

    public static interface TreeProvider {
        public List<String> getChildren(String var1, Watcher var2) throws InterruptedException, KeeperException;
    }
}

