/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.BoundType;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

public class NamespaceBundle
implements ServiceUnitId,
Comparable<NamespaceBundle> {
    private final NamespaceName nsname;
    private final Range<Long> keyRange;
    private final NamespaceBundleFactory factory;
    private boolean hasNonPersistentTopic = false;
    private final String key;
    private final String bundleRange;

    public NamespaceBundle(NamespaceName nsname, Range<Long> keyRange, NamespaceBundleFactory factory) {
        this.nsname = Preconditions.checkNotNull(nsname);
        this.keyRange = Preconditions.checkNotNull(keyRange);
        Preconditions.checkArgument(this.keyRange.lowerBoundType().equals((Object)BoundType.CLOSED), "Invalid hash range. Lower Endpoint has to be inclusive");
        Preconditions.checkArgument(this.keyRange.upperEndpoint().equals(NamespaceBundles.FULL_UPPER_BOUND) && this.keyRange.upperBoundType().equals((Object)BoundType.CLOSED) || !this.keyRange.upperEndpoint().equals(NamespaceBundles.FULL_UPPER_BOUND) && this.keyRange.upperBoundType().equals((Object)BoundType.OPEN), "Invalid hash range. Upper Endpoint should be exclusive unless it is 0xffffffff");
        Preconditions.checkArgument(!this.keyRange.isEmpty(), "Cannot create bundle object for an empty key range");
        this.factory = Preconditions.checkNotNull(factory);
        this.key = NamespaceBundle.getKey(this.nsname, this.keyRange);
        this.bundleRange = String.format("0x%08x_0x%08x", keyRange.lowerEndpoint(), keyRange.upperEndpoint());
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this.nsname;
    }

    @Override
    public String toString() {
        return this.key;
    }

    @Override
    public int compareTo(NamespaceBundle other) {
        if (this.nsname.toString().compareTo(other.nsname.toString()) != 0) {
            return this.nsname.toString().compareTo(other.nsname.toString());
        }
        if (this.equals(other)) {
            return 0;
        }
        try {
            Preconditions.checkState(this.keyRange.intersection(other.keyRange).isEmpty(), "Can't compare two key ranges with non-empty intersection set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException(ise.getMessage(), ise);
        }
        return this.keyRange.lowerEndpoint().compareTo(other.keyRange.lowerEndpoint());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.nsname, this.keyRange.lowerEndpoint(), this.keyRange.lowerBoundType(), this.keyRange.upperEndpoint(), this.keyRange.upperBoundType()});
    }

    public boolean equals(Object other) {
        if (other instanceof NamespaceBundle) {
            NamespaceBundle obj = (NamespaceBundle)other;
            return Objects.equal(this.nsname, obj.nsname) && Objects.equal(this.keyRange.lowerEndpoint(), obj.keyRange.lowerEndpoint()) && Objects.equal((Object)this.keyRange.lowerBoundType(), (Object)obj.keyRange.lowerBoundType()) && Objects.equal(this.keyRange.upperEndpoint(), obj.keyRange.upperEndpoint()) && Objects.equal((Object)this.keyRange.upperBoundType(), (Object)obj.keyRange.upperBoundType());
        }
        return false;
    }

    @Override
    public boolean includes(TopicName topicName) {
        if (!this.nsname.equals(topicName.getNamespaceObject())) {
            return false;
        }
        return this.keyRange.contains(this.factory.getLongHashCode(topicName.toString()));
    }

    public String getBundleRange() {
        return this.bundleRange;
    }

    private static String getKey(NamespaceName nsname, Range<Long> keyRange) {
        return String.format("%s/0x%08x_0x%08x", nsname, keyRange.lowerEndpoint(), keyRange.upperEndpoint());
    }

    Range<Long> getKeyRange() {
        return this.keyRange;
    }

    Long getLowerEndpoint() {
        return this.keyRange.lowerEndpoint();
    }

    Long getUpperEndpoint() {
        return this.keyRange.upperEndpoint();
    }

    public boolean hasNonPersistentTopic() {
        return this.hasNonPersistentTopic;
    }

    public void setHasNonPersistentTopic(boolean hasNonPersistentTopic) {
        this.hasNonPersistentTopic = hasNonPersistentTopic;
    }

    public static String getBundleRange(String namespaceBundle) {
        return namespaceBundle.substring(namespaceBundle.lastIndexOf(47) + 1);
    }

    public static String getBundleNamespace(String namespaceBundle) {
        int index = namespaceBundle.lastIndexOf(47);
        if (index != -1) {
            try {
                return NamespaceName.get(namespaceBundle.substring(0, index)).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return namespaceBundle;
    }

    public NamespaceBundleFactory getNamespaceBundleFactory() {
        return this.factory;
    }
}

