/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.schema;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValue<K, V> {
    private final K key;
    private final V value;

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        KeyValue another = (KeyValue)obj;
        return Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(key = \"").append(this.key).append("\", value = \"").append(this.value).append("\")");
        return sb.toString();
    }

    public static <K, V> byte[] encode(K key, Schema<K> keyWriter, V value, Schema<V> valueWriter) {
        byte[] keyBytes = key == null ? new byte[]{} : keyWriter.encode(key);
        byte[] valueBytes = value == null ? new byte[]{} : valueWriter.encode(value);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + keyBytes.length + 4 + valueBytes.length);
        byteBuffer.putInt(key == null ? -1 : keyBytes.length).put(keyBytes).putInt(value == null ? -1 : valueBytes.length).put(valueBytes);
        return byteBuffer.array();
    }

    public static <K, V> KeyValue<K, V> decode(byte[] data, KeyValueDecoder<K, V> decoder) {
        int valueLength;
        byte[] valueBytes;
        byte[] keyBytes;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int keyLength = byteBuffer.getInt();
        byte[] byArray = keyBytes = keyLength == -1 ? null : new byte[keyLength];
        if (keyBytes != null) {
            byteBuffer.get(keyBytes);
        }
        byte[] byArray2 = valueBytes = (valueLength = byteBuffer.getInt()) == -1 ? null : new byte[valueLength];
        if (valueBytes != null) {
            byteBuffer.get(valueBytes);
        }
        return decoder.decode(keyBytes, valueBytes);
    }

    @FunctionalInterface
    public static interface KeyValueDecoder<K, V> {
        public KeyValue<K, V> decode(byte[] var1, byte[] var2);
    }
}

