/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.annotations;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.util.ReflectUtils;

public class Param {
    public int index;
    public Class<?> type;
    private transient Map<Class<? extends Annotation>, Annotation> annotations;
    public Role role = null;
    private String pathParamName = null;

    public Param(int idx, Class<?> type, Annotation[] annos) {
        this.index = idx;
        this.type = type;
        if (annos != null) {
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation anno : annos) {
                this.annotations.put(anno.annotationType(), anno);
            }
        }
    }

    public void bind(Role role) {
        this.role = role;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (this.annotations == null) {
            return null;
        }
        return (A)this.annotations.get(annotationClass);
    }

    public String getPathParamName() {
        return this.pathParamName;
    }

    public boolean isValid() {
        return this.role != null;
    }

    public void setPathParamName(String name) {
        this.pathParamName = name;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Param[");
        str.append("index=").append(this.index);
        str.append(",type=").append(ReflectUtils.toShortName(this.type));
        str.append(",role=").append((Object)this.role);
        if (this.pathParamName != null) {
            str.append(",pathParamName=").append(this.pathParamName);
        }
        str.append(']');
        return str.toString();
    }

    public void unbind() {
        this.role = null;
    }

    public static enum Role {
        SESSION,
        ENDPOINT_CONFIG,
        CLOSE_REASON,
        ERROR_CAUSE,
        MESSAGE_TEXT,
        MESSAGE_TEXT_STREAM,
        MESSAGE_BINARY,
        MESSAGE_BINARY_STREAM,
        MESSAGE_PONG,
        MESSAGE_PARTIAL_FLAG,
        PATH_PARAM;

        private static Role[] messageRoles;

        public static Role[] getMessageRoles() {
            return messageRoles;
        }

        static {
            messageRoles = new Role[]{MESSAGE_TEXT, MESSAGE_TEXT_STREAM, MESSAGE_BINARY, MESSAGE_BINARY_STREAM, MESSAGE_PONG};
        }
    }
}

