/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders;

import org.apache.pulsar.shade.javax.websocket.DecodeException;
import org.apache.pulsar.shade.javax.websocket.Decoder;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class ShortDecoder
extends AbstractDecoder
implements Decoder.Text<Short> {
    public static final ShortDecoder INSTANCE = new ShortDecoder();

    @Override
    public Short decode(String s) throws DecodeException {
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Short", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

