/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.util;

import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;

public class TransactionUtil {
    public static boolean canTransitionTo(TxnStatus currentStatus, TxnStatus newStatus) {
        switch (currentStatus) {
            case OPEN: {
                return newStatus != TxnStatus.COMMITTED && newStatus != TxnStatus.ABORTED;
            }
            case COMMITTING: {
                return newStatus == TxnStatus.COMMITTING || newStatus == TxnStatus.COMMITTED;
            }
            case COMMITTED: {
                return newStatus == TxnStatus.COMMITTED;
            }
            case ABORTING: {
                return newStatus == TxnStatus.ABORTING || newStatus == TxnStatus.ABORTED;
            }
            case ABORTED: {
                return newStatus == TxnStatus.ABORTED;
            }
        }
        throw new IllegalArgumentException("Unknown txn status : " + (Object)((Object)newStatus));
    }
}

