/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.admin.v1;

import java.util.Collection;
import java.util.Map;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.websocket.admin.WebSocketProxyStatsBase;
import org.apache.pulsar.websocket.stats.ProxyTopicStat;

@Path(value="/proxy-stats")
@Api(value="/proxy", description="Stats for web-socket proxy", tags={"proxy-stats"})
@Produces(value={"application/json"})
public class WebSocketProxyStatsV1
extends WebSocketProxyStatsBase {
    @Override
    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Requested should be executed by Monitoring agent on each proxy to fetch the metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> internalGetMetrics() throws Exception {
        return super.internalGetMetrics();
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public ProxyTopicStat getStats(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        return super.internalGetStats(TopicName.get("persistent", tenant, cluster, namespace, Codec.decode(encodedTopic)));
    }

    @Override
    @GET
    @Path(value="/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Map<String, ProxyTopicStat> internalGetProxyStats() {
        return super.internalGetProxyStats();
    }
}

