/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class EncryptionKeys {
    private String key;
    private int _keyBufferIdx = -1;
    private int _keyBufferLen = -1;
    private static final int _KEY_FIELD_NUMBER = 1;
    private static final int _KEY_TAG = 10;
    private static final int _KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _KEY_MASK = 1;
    private ByteBuf value = null;
    private int _valueIdx = -1;
    private int _valueLen = -1;
    private static final int _VALUE_FIELD_NUMBER = 2;
    private static final int _VALUE_TAG = 18;
    private static final int _VALUE_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _VALUE_MASK = 2;
    private List<KeyValue> metadatas = null;
    private int _metadatasCount = 0;
    private static final int _METADATA_FIELD_NUMBER = 3;
    private static final int _METADATA_TAG = 26;
    private static final int _METADATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasKey() {
        return (this._bitField0 & 1) != 0;
    }

    public String getKey() {
        if (!this.hasKey()) {
            throw new IllegalStateException("Field 'key' is not set");
        }
        if (this.key == null) {
            this.key = LightProtoCodec.readString(this._parsedBuffer, this._keyBufferIdx, this._keyBufferLen);
        }
        return this.key;
    }

    public EncryptionKeys setKey(String key) {
        this.key = key;
        this._bitField0 |= 1;
        this._keyBufferIdx = -1;
        this._keyBufferLen = LightProtoCodec.computeStringUTF8Size(key);
        this._cachedSize = -1;
        return this;
    }

    public EncryptionKeys clearKey() {
        this._bitField0 &= 0xFFFFFFFE;
        this.key = null;
        this._keyBufferIdx = -1;
        this._keyBufferLen = -1;
        return this;
    }

    public boolean hasValue() {
        return (this._bitField0 & 2) != 0;
    }

    public int getValueSize() {
        if (!this.hasValue()) {
            throw new IllegalStateException("Field 'value' is not set");
        }
        return this._valueLen;
    }

    public byte[] getValue() {
        ByteBuf _b = this.getValueSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getValueSlice() {
        if (!this.hasValue()) {
            throw new IllegalStateException("Field 'value' is not set");
        }
        if (this.value == null) {
            return this._parsedBuffer.slice(this._valueIdx, this._valueLen);
        }
        return this.value.slice(0, this._valueLen);
    }

    public EncryptionKeys setValue(byte[] value) {
        this.setValue(Unpooled.wrappedBuffer(value));
        return this;
    }

    public EncryptionKeys setValue(ByteBuf value) {
        this.value = value;
        this._bitField0 |= 2;
        this._valueIdx = -1;
        this._valueLen = value.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public EncryptionKeys clearValue() {
        this._bitField0 &= 0xFFFFFFFD;
        this.value = null;
        this._valueIdx = -1;
        this._valueLen = -1;
        return this;
    }

    public int getMetadatasCount() {
        return this._metadatasCount;
    }

    public KeyValue getMetadataAt(int idx) {
        if (idx < 0 || idx >= this._metadatasCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._metadatasCount + ") for field 'metadata'");
        }
        return this.metadatas.get(idx);
    }

    public List<KeyValue> getMetadatasList() {
        if (this._metadatasCount == 0) {
            return Collections.emptyList();
        }
        return this.metadatas.subList(0, this._metadatasCount);
    }

    public KeyValue addMetadata() {
        if (this.metadatas == null) {
            this.metadatas = new ArrayList<KeyValue>();
        }
        if (this.metadatas.size() == this._metadatasCount) {
            this.metadatas.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.metadatas.get(this._metadatasCount++);
    }

    public EncryptionKeys addAllMetadatas(Iterable<KeyValue> metadatas) {
        for (KeyValue _o : metadatas) {
            this.addMetadata().copyFrom(_o);
        }
        return this;
    }

    public EncryptionKeys clearMetadata() {
        for (int i = 0; i < this._metadatasCount; ++i) {
            this.metadatas.get(i).clear();
        }
        this._metadatasCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._keyBufferLen);
        if (this._keyBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.key, this._keyBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._keyBufferIdx, _b, this._keyBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 18);
        LightProtoCodec.writeVarInt(_b, this._valueLen);
        if (this._valueIdx == -1) {
            _b.writeBytes(this.value);
        } else {
            this._parsedBuffer.getBytes(this._valueIdx, _b, this._valueLen);
        }
        for (int i = 0; i < this._metadatasCount; ++i) {
            KeyValue _item = this.metadatas.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _KEY_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._keyBufferLen);
        _size += this._keyBufferLen;
        _size += _VALUE_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._valueLen) + this._valueLen;
        for (int i = 0; i < this._metadatasCount; ++i) {
            KeyValue _item = this.metadatas.get(i);
            _size += _METADATA_TAG_SIZE;
            int MsgsizeMetadata = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeMetadata) + MsgsizeMetadata;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block5: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._keyBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._keyBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._keyBufferLen);
                    continue block5;
                }
                case 18: {
                    this._bitField0 |= 2;
                    this._valueLen = LightProtoCodec.readVarInt(_buffer);
                    this._valueIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._valueLen);
                    continue block5;
                }
                case 26: {
                    int _metadataSize = LightProtoCodec.readVarInt(_buffer);
                    this.addMetadata().parseFrom(_buffer, _metadataSize);
                    continue block5;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public EncryptionKeys clear() {
        this.key = null;
        this._keyBufferIdx = -1;
        this._keyBufferLen = -1;
        this.value = null;
        this._valueIdx = -1;
        this._valueLen = -1;
        for (int i = 0; i < this._metadatasCount; ++i) {
            this.metadatas.get(i).clear();
        }
        this._metadatasCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public EncryptionKeys copyFrom(EncryptionKeys _other) {
        this._cachedSize = -1;
        if (_other.hasKey()) {
            this.setKey(_other.getKey());
        }
        if (_other.hasValue()) {
            this.setValue(_other.getValue());
        }
        for (int i = 0; i < _other.getMetadatasCount(); ++i) {
            this.addMetadata().copyFrom(_other.getMetadataAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

