/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util.netty;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.io.netty.util.concurrent.Future;

public class NettyFutureUtil {
    public static <V> CompletableFuture<V> toCompletableFuture(Future<V> future) {
        Objects.requireNonNull(future, "future cannot be null");
        CompletableFuture adapter = new CompletableFuture();
        if (future.isDone()) {
            if (future.isSuccess()) {
                adapter.complete(future.getNow());
            } else {
                adapter.completeExceptionally(future.cause());
            }
        } else {
            future.addListener(f -> {
                if (f.isSuccess()) {
                    adapter.complete(f.getNow());
                } else {
                    adapter.completeExceptionally(f.cause());
                }
            });
        }
        return adapter;
    }

    public static CompletableFuture<Void> toCompletableFutureVoid(Future<?> future) {
        Objects.requireNonNull(future, "future cannot be null");
        CompletableFuture<Void> adapter = new CompletableFuture<Void>();
        if (future.isDone()) {
            if (future.isSuccess()) {
                adapter.complete(null);
            } else {
                adapter.completeExceptionally(future.cause());
            }
        } else {
            future.addListener(f -> {
                if (f.isSuccess()) {
                    adapter.complete(null);
                } else {
                    adapter.completeExceptionally(f.cause());
                }
            });
        }
        return adapter;
    }
}

