/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.resources.LoadManagerReportResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreCacheLoader
implements Closeable {
    private final LoadManagerReportResources loadReportResources;
    private final int operationTimeoutMs;
    private volatile List<LoadManagerReport> availableBrokers;
    private final OrderedScheduler orderedExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(8).name("pulsar-metadata-cache-loader-ordered-cache").build();
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreCacheLoader.class);

    public MetadataStoreCacheLoader(PulsarResources pulsarResources, int operationTimeoutMs) throws Exception {
        this.loadReportResources = pulsarResources.getLoadReportResources();
        this.operationTimeoutMs = operationTimeoutMs;
        this.init();
    }

    public void init() throws Exception {
        this.loadReportResources.getStore().registerListener(n -> {
            if (LOADBALANCE_BROKERS_ROOT.equals(n.getPath()) && NotificationType.ChildrenChanged.equals((Object)n.getType())) {
                ((CompletableFuture)this.loadReportResources.getChildrenAsync(LOADBALANCE_BROKERS_ROOT).thenApplyAsync(brokerNodes -> {
                    ((CompletableFuture)this.updateBrokerList((List<String>)brokerNodes).thenRun(() -> log.info("Successfully updated broker info {}", brokerNodes))).exceptionally(ex -> {
                        log.warn("Error updating broker info after broker list changed", ex);
                        return null;
                    });
                    return null;
                })).exceptionally(ex -> {
                    log.warn("Error updating broker info after broker list changed", ex);
                    return null;
                });
            }
        });
        this.updateBrokerList(this.loadReportResources.getChildren(LOADBALANCE_BROKERS_ROOT)).get(this.operationTimeoutMs, TimeUnit.SECONDS);
    }

    public List<LoadManagerReport> getAvailableBrokers() {
        if (CollectionUtils.isEmpty(this.availableBrokers)) {
            try {
                this.updateBrokerList(this.loadReportResources.getChildren(LOADBALANCE_BROKERS_ROOT));
            }
            catch (Exception e) {
                log.warn("Error updating broker from zookeeper.", (Throwable)e);
            }
        }
        return this.availableBrokers;
    }

    @Override
    public void close() throws IOException {
        this.orderedExecutor.shutdown();
    }

    private CompletableFuture<Void> updateBrokerList(List<String> brokerNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (brokerNodes.isEmpty()) {
            this.availableBrokers = new ArrayList<LoadManagerReport>();
            future.complete(null);
            return future;
        }
        ArrayList loadReportFutureList = new ArrayList();
        for (String broker : brokerNodes) {
            loadReportFutureList.add(this.loadReportResources.getAsync("/loadbalance/brokers/" + broker));
        }
        ((CompletableFuture)FutureUtil.waitForAll(loadReportFutureList).thenRun(() -> {
            ArrayList<LoadManagerReport> newAvailableBrokers = new ArrayList<LoadManagerReport>(brokerNodes.size());
            for (CompletableFuture loadReportFuture : loadReportFutureList) {
                try {
                    Optional loadReport = (Optional)loadReportFuture.get();
                    if (!loadReport.isPresent()) continue;
                    newAvailableBrokers.add((LoadManagerReport)loadReport.get());
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
            }
            this.availableBrokers = newAvailableBrokers;
            future.complete(null);
        })).exceptionally(ex -> {
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }
}

