/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats;

import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

class ServerStats {
    private final Counter rpcStarted;
    private final Counter rpcCompleted;
    private final Counter streamMessagesReceived;
    private final Counter streamMessagesSent;
    private final Optional<OpStatsLogger> completedLatencyMicros;

    private ServerStats(StatsLogger rootStatsLogger, boolean includeLatencyHistograms, boolean streamRequests, boolean streamResponses) {
        this.rpcStarted = rootStatsLogger.getCounter("grpc_started");
        this.rpcCompleted = rootStatsLogger.getCounter("grpc_completed");
        this.streamMessagesReceived = streamRequests ? rootStatsLogger.getCounter("grpc_msg_received") : NullStatsLogger.INSTANCE.getCounter("grpc_msg_received");
        this.streamMessagesSent = streamResponses ? rootStatsLogger.getCounter("grpc_msg_sent") : NullStatsLogger.INSTANCE.getCounter("grpc_msg_sent");
        this.completedLatencyMicros = includeLatencyHistograms ? Optional.of(rootStatsLogger.getOpStatsLogger("grpc_latency_micros")) : Optional.empty();
    }

    public void recordCallStarted() {
        this.rpcStarted.inc();
    }

    public void recordServerHandled(Status.Code code) {
        this.rpcCompleted.inc();
    }

    public void recordStreamMessageSent() {
        this.streamMessagesSent.inc();
    }

    public void recordStreamMessageReceived() {
        this.streamMessagesReceived.inc();
    }

    public boolean shouldRecordLatency() {
        return this.completedLatencyMicros.isPresent();
    }

    public void recordLatency(boolean success, long latencyMicros) {
        this.completedLatencyMicros.ifPresent(latencyLogger -> {
            if (success) {
                latencyLogger.registerSuccessfulEvent(latencyMicros, TimeUnit.MICROSECONDS);
            } else {
                latencyLogger.registerFailedEvent(latencyMicros, TimeUnit.MICROSECONDS);
            }
        });
    }

    static class Factory {
        private final boolean includeLatencyHistograms;

        Factory(boolean includeLatencyHistograms) {
            this.includeLatencyHistograms = includeLatencyHistograms;
        }

        <ReqT, RespT> ServerStats createMetricsForMethod(MethodDescriptor<ReqT, RespT> methodDescriptor, StatsLogger statsLogger) {
            String fullMethodName = methodDescriptor.getFullMethodName();
            String serviceName = MethodDescriptor.extractFullServiceName((String)fullMethodName);
            String methodName = fullMethodName.substring(serviceName.length() + 1);
            MethodDescriptor.MethodType type = methodDescriptor.getType();
            return new ServerStats(statsLogger.scope(methodName), this.includeLatencyHistograms, type == MethodDescriptor.MethodType.CLIENT_STREAMING || type == MethodDescriptor.MethodType.BIDI_STREAMING, type == MethodDescriptor.MethodType.SERVER_STREAMING || type == MethodDescriptor.MethodType.BIDI_STREAMING);
        }
    }
}

