/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.Map;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.impl.AutoFailoverPolicyFactory;

@ApiModel(value="AutoFailoverPolicyData", description="The auto failover policy configuration data")
public class AutoFailoverPolicyDataImpl
implements AutoFailoverPolicyData {
    @ApiModelProperty(name="policy_type", value="The auto failover policy type", allowableValues="min_available")
    @JsonProperty(value="policy_type")
    private AutoFailoverPolicyType policyType;
    @ApiModelProperty(name="parameters", value="The parameters applied to the auto failover policy specified by `policy_type`.\nThe parameters for 'min_available' are :\n  - 'min_limit': the limit of minimal number of available brokers in primary group before auto failover\n  - 'usage_threshold': the resource usage threshold. If the usage of a broker is beyond this value, it would be marked as unavailable\n", example="{\n  \"min_limit\": 3,\n  \"usage_threshold\": 80\n}\n")
    private Map<String, String> parameters;

    public static AutoFailoverPolicyDataImplBuilder builder() {
        return new AutoFailoverPolicyDataImplBuilder();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.policyType != null && this.parameters != null);
        AutoFailoverPolicyFactory.create(this);
    }

    @Override
    public AutoFailoverPolicyType getPolicyType() {
        return this.policyType;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="policy_type")
    public void setPolicyType(AutoFailoverPolicyType policyType) {
        this.policyType = policyType;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoFailoverPolicyDataImpl)) {
            return false;
        }
        AutoFailoverPolicyDataImpl other = (AutoFailoverPolicyDataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AutoFailoverPolicyType this$policyType = this.getPolicyType();
        AutoFailoverPolicyType other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !((Object)((Object)this$policyType)).equals((Object)other$policyType)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoFailoverPolicyDataImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AutoFailoverPolicyType $policyType = this.getPolicyType();
        result = result * 59 + ($policyType == null ? 43 : ((Object)((Object)$policyType)).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "AutoFailoverPolicyDataImpl(policyType=" + (Object)((Object)this.getPolicyType()) + ", parameters=" + this.getParameters() + ")";
    }

    public AutoFailoverPolicyDataImpl() {
    }

    public AutoFailoverPolicyDataImpl(AutoFailoverPolicyType policyType, Map<String, String> parameters) {
        this.policyType = policyType;
        this.parameters = parameters;
    }

    public static class AutoFailoverPolicyDataImplBuilder
    implements AutoFailoverPolicyData.Builder {
        private AutoFailoverPolicyType policyType;
        private Map<String, String> parameters;

        @Override
        public AutoFailoverPolicyDataImplBuilder policyType(AutoFailoverPolicyType policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public AutoFailoverPolicyDataImplBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public AutoFailoverPolicyDataImpl build() {
            return new AutoFailoverPolicyDataImpl(this.policyType, this.parameters);
        }
    }
}

