/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;

public class PersistentOfflineTopicStats {
    public long storageSize;
    public long totalMessages;
    public long messageBacklog;
    public final String brokerName;
    public final String topicName;
    public List<LedgerDetails> dataLedgerDetails;
    public Map<String, CursorDetails> cursorDetails;
    public Date statGeneratedAt;

    public PersistentOfflineTopicStats(String topicName, String brokerName) {
        this.brokerName = brokerName;
        this.topicName = topicName;
        this.dataLedgerDetails = Lists.newArrayList();
        this.cursorDetails = Maps.newHashMap();
        this.statGeneratedAt = new Date(System.currentTimeMillis());
    }

    public void reset() {
        this.storageSize = 0L;
        this.totalMessages = 0L;
        this.messageBacklog = 0L;
        this.dataLedgerDetails.clear();
        this.cursorDetails.clear();
        this.statGeneratedAt.setTime(System.currentTimeMillis());
    }

    public void addCursorDetails(String cursor, long backlog, long ledgerId) {
        this.cursorDetails.put(cursor, new CursorDetails(backlog, ledgerId));
    }

    public void addLedgerDetails(long entries, long timestamp, long size, long ledgerId) {
        this.dataLedgerDetails.add(new LedgerDetails(entries, timestamp, size, ledgerId));
    }

    public static class LedgerDetails {
        public long entries;
        public long timestamp;
        public long size;
        public long ledgerId;

        public LedgerDetails(long entries, long timestamp, long size, long ledgerId) {
            this.entries = entries;
            this.timestamp = timestamp;
            this.size = size;
            this.ledgerId = ledgerId;
        }
    }

    public static class CursorDetails {
        public long cursorBacklog;
        public long cursorLedgerId;

        public CursorDetails(long cursorBacklog, long cursorLedgerId) {
            this.cursorBacklog = cursorBacklog;
            this.cursorLedgerId = cursorLedgerId;
        }
    }
}

