/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.InMemoryDelayedDeliveryTracker;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.io.netty.util.Timer;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;

public class InMemoryDelayedDeliveryTrackerFactory
implements DelayedDeliveryTrackerFactory {
    private Timer timer;
    private long tickTimeMillis;
    private boolean isDelayedDeliveryDeliverAtTimeStrict;

    @Override
    public void initialize(ServiceConfiguration config) {
        this.timer = new HashedWheelTimer(new DefaultThreadFactory("pulsar-delayed-delivery"), config.getDelayedDeliveryTickTimeMillis(), TimeUnit.MILLISECONDS);
        this.tickTimeMillis = config.getDelayedDeliveryTickTimeMillis();
        this.isDelayedDeliveryDeliverAtTimeStrict = config.isDelayedDeliveryDeliverAtTimeStrict();
    }

    @Override
    public DelayedDeliveryTracker newTracker(PersistentDispatcherMultipleConsumers dispatcher) {
        return new InMemoryDelayedDeliveryTracker(dispatcher, this.timer, this.tickTimeMillis, this.isDelayedDeliveryDeliverAtTimeStrict);
    }

    @Override
    public void close() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

