/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class SendMessageInfo {
    private int totalMessages;
    private long totalBytes;
    private int totalChunkedMessages;
    private static final FastThreadLocal<SendMessageInfo> THREAD_LOCAL = new FastThreadLocal<SendMessageInfo>(){

        @Override
        protected SendMessageInfo initialValue() throws Exception {
            return new SendMessageInfo();
        }
    };

    private SendMessageInfo() {
    }

    public static SendMessageInfo getThreadLocal() {
        SendMessageInfo smi = THREAD_LOCAL.get();
        smi.totalMessages = 0;
        smi.totalBytes = 0L;
        smi.totalChunkedMessages = 0;
        return smi;
    }

    public int getTotalMessages() {
        return this.totalMessages;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int getTotalChunkedMessages() {
        return this.totalChunkedMessages;
    }

    public void setTotalMessages(int totalMessages) {
        this.totalMessages = totalMessages;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setTotalChunkedMessages(int totalChunkedMessages) {
        this.totalChunkedMessages = totalChunkedMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageInfo)) {
            return false;
        }
        SendMessageInfo other = (SendMessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalMessages() != other.getTotalMessages()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        return this.getTotalChunkedMessages() == other.getTotalChunkedMessages();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMessageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalMessages();
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        result = result * 59 + this.getTotalChunkedMessages();
        return result;
    }

    public String toString() {
        return "SendMessageInfo(totalMessages=" + this.getTotalMessages() + ", totalBytes=" + this.getTotalBytes() + ", totalChunkedMessages=" + this.getTotalChunkedMessages() + ")";
    }
}

