/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.pulsar.shade.org.eclipse.jetty.io.EndPoint;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;

public class PulsarServerConnector
extends ServerConnector {
    private final Semaphore semaphore = new Semaphore(10000);

    public PulsarServerConnector(Server server, int acceptors, int selectors) {
        super(server, acceptors, selectors);
    }

    public PulsarServerConnector(Server server, int acceptors, int selectors, SslContextFactory sslContextFactory) {
        super(server, acceptors, selectors, sslContextFactory);
    }

    @Override
    public void accept(int acceptorID) throws IOException {
        try {
            this.semaphore.acquire();
            super.accept(acceptorID);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void onEndPointClosed(EndPoint endp) {
        this.semaphore.release();
        super.onEndPointClosed(endp);
    }
}

