/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.client.impl.BatchMessageContainerBase;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchMessageContainer
implements BatchMessageContainerBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchMessageContainer.class);
    protected CompressionType compressionType;
    protected CompressionCodec compressor;
    protected String topicName;
    protected String producerName;
    protected ProducerImpl producer;
    protected int maxNumMessagesInBatch;
    protected int maxBytesInBatch;
    protected int numMessagesInBatch = 0;
    protected long currentBatchSizeBytes = 0L;
    protected long currentTxnidMostBits = -1L;
    protected long currentTxnidLeastBits = -1L;
    protected static final int INITIAL_BATCH_BUFFER_SIZE = 1024;
    protected int maxBatchSize = 1024;

    @Override
    public boolean haveEnoughSpace(MessageImpl<?> msg) {
        int messageSize = msg.getDataBuffer().readableBytes();
        return (this.maxBytesInBatch <= 0 && (long)messageSize + this.currentBatchSizeBytes <= (long)ClientCnx.getMaxMessageSize() || this.maxBytesInBatch > 0 && (long)messageSize + this.currentBatchSizeBytes <= (long)this.maxBytesInBatch) && (this.maxNumMessagesInBatch <= 0 || this.numMessagesInBatch < this.maxNumMessagesInBatch);
    }

    protected boolean isBatchFull() {
        return this.maxBytesInBatch > 0 && this.currentBatchSizeBytes >= (long)this.maxBytesInBatch || this.maxBytesInBatch <= 0 && this.currentBatchSizeBytes >= (long)ClientCnx.getMaxMessageSize() || this.maxNumMessagesInBatch > 0 && this.numMessagesInBatch >= this.maxNumMessagesInBatch;
    }

    @Override
    public int getNumMessagesInBatch() {
        return this.numMessagesInBatch;
    }

    @Override
    public long getCurrentBatchSize() {
        return this.currentBatchSizeBytes;
    }

    @Override
    public List<ProducerImpl.OpSendMsg> createOpSendMsgs() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProducerImpl.OpSendMsg createOpSendMsg() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProducer(ProducerImpl<?> producer) {
        this.producer = producer;
        this.topicName = producer.getTopic();
        this.producerName = producer.getProducerName();
        this.compressionType = CompressionCodecProvider.convertToWireProtocol(producer.getConfiguration().getCompressionType());
        this.compressor = CompressionCodecProvider.getCompressionCodec(this.compressionType);
        this.maxNumMessagesInBatch = producer.getConfiguration().getBatchingMaxMessages();
        this.maxBytesInBatch = producer.getConfiguration().getBatchingMaxBytes();
    }

    @Override
    public boolean hasSameTxn(MessageImpl<?> msg) {
        if (!msg.getMessageBuilder().hasTxnidMostBits() || !msg.getMessageBuilder().hasTxnidLeastBits()) {
            return true;
        }
        if (this.currentTxnidMostBits == -1L || this.currentTxnidLeastBits == -1L) {
            this.currentTxnidMostBits = msg.getMessageBuilder().getTxnidMostBits();
            this.currentTxnidLeastBits = msg.getMessageBuilder().getTxnidLeastBits();
            return true;
        }
        return this.currentTxnidMostBits == msg.getMessageBuilder().getTxnidMostBits() && this.currentTxnidLeastBits == msg.getMessageBuilder().getTxnidLeastBits();
    }
}

