/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.BrokerData;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.LoadSheddingStrategy;
import org.apache.pulsar.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.pulsar.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdShedder
implements LoadSheddingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ThresholdShedder.class);
    private final Multimap<String, String> selectedBundlesCache = ArrayListMultimap.create();
    private static final double ADDITIONAL_THRESHOLD_PERCENT_MARGIN = 0.05;
    private static final double MB = 1048576.0;
    private static final long LOAD_LOG_SAMPLE_DELAY_IN_SEC = 300L;
    private final Map<String, Double> brokerAvgResourceUsage = new HashMap<String, Double>();
    private long lastSampledLoadLogTS = 0L;

    private static int toPercentage(double usage) {
        return (int)(usage * 100.0);
    }

    private boolean canSampleLog() {
        boolean sampleLog;
        long now = System.currentTimeMillis() / 1000L;
        boolean bl = sampleLog = now - this.lastSampledLoadLogTS >= 300L;
        if (sampleLog) {
            this.lastSampledLoadLogTS = now;
        }
        return sampleLog;
    }

    @Override
    public Multimap<String, String> findBundlesForUnloading(LoadData loadData, ServiceConfiguration conf) {
        this.selectedBundlesCache.clear();
        boolean sampleLog = this.canSampleLog();
        double threshold = (double)conf.getLoadBalancerBrokerThresholdShedderPercentage() / 100.0;
        Map<String, Long> recentlyUnloadedBundles = loadData.getRecentlyUnloadedBundles();
        double minThroughputThreshold = conf.getLoadBalancerBundleUnloadMinThroughputThreshold() * 1048576.0;
        double avgUsage = this.getBrokerAvgUsage(loadData, conf.getLoadBalancerHistoryResourcePercentage(), conf, sampleLog);
        if (sampleLog) {
            log.info("brokers' resource avgUsage:{}%", (Object)ThresholdShedder.toPercentage(avgUsage));
        }
        if (avgUsage == 0.0) {
            log.warn("average max resource usage is 0");
            return this.selectedBundlesCache;
        }
        loadData.getBrokerData().forEach((broker, brokerData) -> {
            LocalBrokerData localData = brokerData.getLocalData();
            double currentUsage = this.brokerAvgResourceUsage.getOrDefault(broker, 0.0);
            if (currentUsage < avgUsage + threshold) {
                if (sampleLog) {
                    log.info("[{}] broker is not overloaded, ignoring at this point, currentUsage:{}%", broker, (Object)ThresholdShedder.toPercentage(currentUsage));
                }
                return;
            }
            double percentOfTrafficToOffload = currentUsage - avgUsage - threshold + 0.05;
            double brokerCurrentThroughput = localData.getMsgThroughputIn() + localData.getMsgThroughputOut();
            double minimumThroughputToOffload = brokerCurrentThroughput * percentOfTrafficToOffload;
            if (minimumThroughputToOffload < minThroughputThreshold) {
                if (sampleLog) {
                    log.info("[{}] broker is planning to shed throughput {} MByte/s less than minimumThroughputThreshold {} MByte/s, skipping bundle unload.", new Object[]{broker, minimumThroughputToOffload / 1048576.0, minThroughputThreshold / 1048576.0});
                }
                return;
            }
            log.info("Attempting to shed load on {}, which has max resource usage above avgUsage  and threshold {}% > {}% + {}% -- Offloading at least {} MByte/s of traffic, left throughput {} MByte/s", new Object[]{broker, currentUsage, avgUsage, threshold, minimumThroughputToOffload / 1048576.0, (brokerCurrentThroughput - minimumThroughputToOffload) / 1048576.0});
            MutableDouble trafficMarkedToOffload = new MutableDouble(0.0);
            MutableBoolean atLeastOneBundleSelected = new MutableBoolean(false);
            if (localData.getBundles().size() > 1) {
                loadData.getBundleDataForLoadShedding().entrySet().stream().map(e -> {
                    String bundle = (String)e.getKey();
                    BundleData bundleData = (BundleData)e.getValue();
                    TimeAverageMessageData shortTermData = bundleData.getShortTermData();
                    double throughput = shortTermData.getMsgThroughputIn() + shortTermData.getMsgThroughputOut();
                    return Pair.of(bundle, throughput);
                }).filter(e -> !recentlyUnloadedBundles.containsKey(e.getLeft())).filter(e -> localData.getBundles().contains(e.getLeft())).sorted((e1, e2) -> Double.compare((Double)e2.getRight(), (Double)e1.getRight())).forEach(e -> {
                    if (trafficMarkedToOffload.doubleValue() < minimumThroughputToOffload || atLeastOneBundleSelected.isFalse()) {
                        this.selectedBundlesCache.put((String)broker, (String)e.getLeft());
                        trafficMarkedToOffload.add((Number)e.getRight());
                        atLeastOneBundleSelected.setTrue();
                    }
                });
            } else if (localData.getBundles().size() == 1) {
                log.warn("HIGH USAGE WARNING : Sole namespace bundle {} is overloading broker {}. No Load Shedding will be done on this broker", (Object)localData.getBundles().iterator().next(), broker);
            } else {
                log.warn("Broker {} is overloaded despite having no bundles", broker);
            }
        });
        return this.selectedBundlesCache;
    }

    private double getBrokerAvgUsage(LoadData loadData, double historyPercentage, ServiceConfiguration conf, boolean sampleLog) {
        double totalUsage = 0.0;
        int totalBrokers = 0;
        for (Map.Entry<String, BrokerData> entry : loadData.getBrokerData().entrySet()) {
            LocalBrokerData localBrokerData = entry.getValue().getLocalData();
            String broker = entry.getKey();
            totalUsage += this.updateAvgResourceUsage(broker, localBrokerData, historyPercentage, conf, sampleLog);
            ++totalBrokers;
        }
        return totalBrokers > 0 ? totalUsage / (double)totalBrokers : 0.0;
    }

    private double updateAvgResourceUsage(String broker, LocalBrokerData localBrokerData, double historyPercentage, ServiceConfiguration conf, boolean sampleLog) {
        Double historyUsage = this.brokerAvgResourceUsage.get(broker);
        double resourceUsage = localBrokerData.getMaxResourceUsageWithWeight(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight());
        if (sampleLog) {
            log.info("{} broker load: historyUsage={}%, resourceUsage={}%", new Object[]{broker, historyUsage == null ? 0 : ThresholdShedder.toPercentage(historyUsage), ThresholdShedder.toPercentage(resourceUsage)});
        }
        if (resourceUsage > 1.0) {
            log.error("{} broker resourceUsage is bigger than 100%. Some of the resource limits are mis-configured. Try to disable the error resource signals by setting their weights to zero or fix the resource limit configurations. Ref:https://pulsar.apache.org/docs/administration-load-balance/#thresholdshedder ResourceUsage:[{}], CPUResourceWeight:{}, MemoryResourceWeight:{}, DirectMemoryResourceWeight:{}, BandwithInResourceWeight:{}, BandwithOutResourceWeight:{}", new Object[]{broker, localBrokerData.printResourceUsage(), conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight()});
            resourceUsage = localBrokerData.getMaxResourceUsageWithWeightWithinLimit(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight());
            log.warn("{} broker recomputed max resourceUsage={}%. Skipped usage signals bigger than 100%", (Object)broker, (Object)ThresholdShedder.toPercentage(resourceUsage));
        }
        historyUsage = historyUsage == null ? resourceUsage : historyUsage * historyPercentage + (1.0 - historyPercentage) * resourceUsage;
        this.brokerAvgResourceUsage.put(broker, historyUsage);
        return historyUsage;
    }
}

