/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.ConcurrentLongLongPairHashMap;
import org.apache.pulsar.utils.ConcurrentBitmapSortedLongPairSet;

public class MessageRedeliveryController {
    private final ConcurrentBitmapSortedLongPairSet messagesToRedeliver = new ConcurrentBitmapSortedLongPairSet();
    private final ConcurrentLongLongPairHashMap hashesToBeBlocked;

    public MessageRedeliveryController(boolean allowOutOfOrderDelivery) {
        this.hashesToBeBlocked = allowOutOfOrderDelivery ? null : ConcurrentLongLongPairHashMap.newBuilder().concurrencyLevel(2).expectedItems(128).autoShrink(true).build();
    }

    public void add(long ledgerId, long entryId) {
        this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public void add(long ledgerId, long entryId, long stickyKeyHash) {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.put(ledgerId, entryId, stickyKeyHash, 0L);
        }
        this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public void remove(long ledgerId, long entryId) {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.remove(ledgerId, entryId);
        }
        this.messagesToRedeliver.remove(ledgerId, entryId);
    }

    public void removeAllUpTo(long markDeleteLedgerId, long markDeleteEntryId) {
        if (this.hashesToBeBlocked != null) {
            ArrayList keysToRemove = new ArrayList();
            this.hashesToBeBlocked.forEach((ledgerId, entryId, stickyKeyHash, none) -> {
                if (ComparisonChain.start().compare(ledgerId, markDeleteLedgerId).compare(entryId, markDeleteEntryId).result() <= 0) {
                    keysToRemove.add(new ConcurrentLongLongPairHashMap.LongPair(ledgerId, entryId));
                }
            });
            keysToRemove.forEach(longPair -> this.hashesToBeBlocked.remove(longPair.first, longPair.second));
            keysToRemove.clear();
        }
        this.messagesToRedeliver.removeUpTo(markDeleteLedgerId, markDeleteEntryId + 1L);
    }

    public boolean isEmpty() {
        return this.messagesToRedeliver.isEmpty();
    }

    public void clear() {
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.clear();
        }
        this.messagesToRedeliver.clear();
    }

    public String toString() {
        return this.messagesToRedeliver.toString();
    }

    public boolean containsStickyKeyHashes(Set<Integer> stickyKeyHashes) {
        AtomicBoolean isContained = new AtomicBoolean(false);
        if (this.hashesToBeBlocked != null) {
            this.hashesToBeBlocked.forEach((ledgerId, entryId, stickyKeyHash, none) -> {
                if (!isContained.get() && stickyKeyHashes.contains((int)stickyKeyHash)) {
                    isContained.set(true);
                }
            });
        }
        return isContained.get();
    }

    public Set<PositionImpl> getMessagesToReplayNow(int maxMessagesToRead) {
        return this.messagesToRedeliver.items(maxMessagesToRead, PositionImpl::new);
    }
}

