/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGenerator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.javax.servlet.AsyncContext;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.http.HttpServlet;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util.SafeRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final PulsarService pulsar;
    private final boolean shouldExportTopicMetrics;
    private final boolean shouldExportConsumerMetrics;
    private final boolean shouldExportProducerMetrics;
    private final long metricsServletTimeoutMs;
    private final boolean splitTopicAndPartitionLabel;
    private List<PrometheusRawMetricsProvider> metricsProviders;
    private ExecutorService executor = null;
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsServlet.class);

    public PrometheusMetricsServlet(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean shouldExportProducerMetrics, boolean splitTopicAndPartitionLabel) {
        this.pulsar = pulsar;
        this.shouldExportTopicMetrics = includeTopicMetrics;
        this.shouldExportConsumerMetrics = includeConsumerMetrics;
        this.shouldExportProducerMetrics = shouldExportProducerMetrics;
        this.metricsServletTimeoutMs = pulsar.getConfiguration().getMetricsServletTimeoutMs();
        this.splitTopicAndPartitionLabel = splitTopicAndPartitionLabel;
    }

    @Override
    public void init() throws ServletException {
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("prometheus-stats"));
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext context = request.startAsync();
        context.setTimeout(this.metricsServletTimeoutMs);
        this.executor.execute(SafeRun.safeRun(() -> {
            HttpServletResponse res = (HttpServletResponse)context.getResponse();
            try {
                res.setStatus(200);
                res.setContentType("text/plain;charset=utf-8");
                PrometheusMetricsGenerator.generate(this.pulsar, this.shouldExportTopicMetrics, this.shouldExportConsumerMetrics, this.shouldExportProducerMetrics, this.splitTopicAndPartitionLabel, res.getOutputStream(), this.metricsProviders);
                context.complete();
            }
            catch (Exception e) {
                log.error("Failed to generate prometheus stats", (Throwable)e);
                res.setStatus(500);
                context.complete();
            }
        }));
    }

    @Override
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void addRawMetricsProvider(PrometheusRawMetricsProvider metricsProvider) {
        if (this.metricsProviders == null) {
            this.metricsProviders = new LinkedList<PrometheusRawMetricsProvider>();
        }
        this.metricsProviders.add(metricsProvider);
    }
}

