/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.functions.api.KVRecord;
import org.apache.pulsar.functions.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkRecord<T>
implements Record<T> {
    private static final Logger log = LoggerFactory.getLogger(SinkRecord.class);
    private final Record<T> sourceRecord;
    private final T value;

    public Record<T> getSourceRecord() {
        return this.sourceRecord;
    }

    @Override
    public Optional<String> getTopicName() {
        return this.sourceRecord.getTopicName();
    }

    @Override
    public Optional<String> getKey() {
        return this.sourceRecord.getKey();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public Optional<String> getPartitionId() {
        return this.sourceRecord.getPartitionId();
    }

    @Override
    public Optional<Integer> getPartitionIndex() {
        return this.sourceRecord.getPartitionIndex();
    }

    @Override
    public Optional<Long> getRecordSequence() {
        return this.sourceRecord.getRecordSequence();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.sourceRecord.getProperties();
    }

    @Override
    public void ack() {
        this.sourceRecord.ack();
    }

    @Override
    public void fail() {
        this.sourceRecord.fail();
    }

    @Override
    public Optional<String> getDestinationTopic() {
        return this.sourceRecord.getDestinationTopic();
    }

    @Override
    public Schema<T> getSchema() {
        if (this.sourceRecord == null) {
            return null;
        }
        if (this.sourceRecord.getSchema() != null) {
            Schema<Object> schema = this.sourceRecord.getSchema();
            if (schema instanceof AutoConsumeSchema) {
                schema = this.sourceRecord.getMessage().isPresent() && this.sourceRecord.getMessage().get().getReaderSchema().isPresent() ? this.sourceRecord.getMessage().get().getReaderSchema().get() : ((AutoConsumeSchema)schema).getInternalSchema();
            }
            return schema;
        }
        if (this.sourceRecord instanceof KVRecord) {
            KVRecord kvRecord = (KVRecord)this.sourceRecord;
            return KeyValueSchemaImpl.of(kvRecord.getKeySchema(), kvRecord.getValueSchema(), kvRecord.getKeyValueEncodingType());
        }
        return null;
    }

    @Override
    public Optional<Long> getEventTime() {
        return this.sourceRecord.getEventTime();
    }

    @Override
    public Optional<Message<T>> getMessage() {
        return this.sourceRecord.getMessage();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkRecord)) {
            return false;
        }
        SinkRecord other = (SinkRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Record<T> this$sourceRecord = this.getSourceRecord();
        Record<T> other$sourceRecord = other.getSourceRecord();
        if (this$sourceRecord == null ? other$sourceRecord != null : !this$sourceRecord.equals(other$sourceRecord)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Record<T> $sourceRecord = this.getSourceRecord();
        result = result * 59 + ($sourceRecord == null ? 43 : $sourceRecord.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "SinkRecord(sourceRecord=" + this.getSourceRecord() + ", value=" + this.getValue() + ")";
    }

    public SinkRecord(Record<T> sourceRecord, T value) {
        this.sourceRecord = sourceRecord;
        this.value = value;
    }
}

