/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Supplier;
import org.apache.pulsar.functions.instance.stats.PrometheusTextFormat;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.LeaderService;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Gauge;
import org.apache.pulsar.shade.io.prometheus.client.Summary;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.DefaultExports;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmMetrics;

public class WorkerStatsManager {
    private static final String PULSAR_FUNCTION_WORKER_METRICS_PREFIX = "pulsar_function_worker_";
    private static final String START_UP_TIME = "start_up_time_ms";
    private static final String INSTANCE_COUNT = "instance_count";
    private static final String TOTAL_EXPECTED_INSTANCE_COUNT = "total_expected_instance_count";
    private static final String TOTAL_FUNCTIONS_COUNT = "total_function_count";
    private static final String SCHEDULE_TOTAL_EXEC_TIME = "schedule_execution_time_total_ms";
    private static final String SCHEDULE_STRATEGY_EXEC_TIME = "schedule_strategy_execution_time_ms";
    private static final String REBALANCE_TOTAL_EXEC_TIME = "rebalance_execution_time_total_ms";
    private static final String REBALANCE_STRATEGY_EXEC_TIME = "rebalance_strategy_execution_time_ms";
    private static final String STOPPING_INSTANCE_PROCESS_TIME = "stop_instance_process_time_ms";
    private static final String STARTING_INSTANCE_PROCESS_TIME = "start_instance_process_time_ms";
    private static final String DRAIN_TOTAL_EXEC_TIME = "drain_execution_time_total_ms";
    private static final String IS_LEADER = "is_leader";
    private static final String[] metricsLabelNames;
    private final String[] metricsLabels;
    private FunctionRuntimeManager functionRuntimeManager;
    private FunctionMetaDataManager functionMetaDataManager;
    private LeaderService leaderService;
    private Supplier<Boolean> isLeader;
    private CollectorRegistry collectorRegistry = new CollectorRegistry();
    private final Summary statWorkerStartupTime;
    private final Gauge statNumInstances;
    private final Summary scheduleTotalExecutionTime;
    private final Summary scheduleStrategyExecutionTime;
    private final Summary rebalanceTotalExecutionTime;
    private final Summary rebalanceStrategyExecutionTime;
    private final Summary stopInstanceProcessTime;
    private final Summary startInstanceProcessTime;
    private final Summary drainTotalExecutionTime;
    private final Summary.Child _statWorkerStartupTime;
    private final Gauge.Child _statNumInstances;
    private final Summary.Child _scheduleTotalExecutionTime;
    private final Summary.Child _scheduleStrategyExecutionTime;
    private final Summary.Child _rebalanceTotalExecutionTime;
    private final Summary.Child _rebalanceStrategyExecutionTime;
    private final Summary.Child _stopInstanceProcessTime;
    private final Summary.Child _startInstanceProcessTime;
    private final Summary.Child _drainTotalExecutionTime;
    private Long startupTimeStart;
    private Long scheduleTotalExecTimeStart;
    private Long scheduleStrategyExecTimeStart;
    private Long rebalanceTotalExecTimeStart;
    private Long rebalanceStrategyExecTimeStart;
    private Long drainTotalExecTimeStart;
    private Long stopInstanceProcessTimeStart;
    private Long startInstanceProcessTimeStart;

    public WorkerStatsManager(WorkerConfig workerConfig, boolean runAsStandalone) {
        this.metricsLabels = new String[]{workerConfig.getPulsarFunctionsCluster()};
        this.statWorkerStartupTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_start_up_time_ms")).help("Worker service startup time in milliseconds.")).labelNames(metricsLabelNames)).register(this.collectorRegistry);
        this._statWorkerStartupTime = (Summary.Child)this.statWorkerStartupTime.labels(this.metricsLabels);
        this.statNumInstances = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_worker_instance_count")).help("Number of instances run by this worker.")).labelNames(metricsLabelNames)).register(this.collectorRegistry);
        this._statNumInstances = (Gauge.Child)this.statNumInstances.labels(this.metricsLabels);
        this.scheduleTotalExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_schedule_execution_time_total_ms")).help("Total execution time of schedule in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._scheduleTotalExecutionTime = (Summary.Child)this.scheduleTotalExecutionTime.labels(this.metricsLabels);
        this.scheduleStrategyExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_schedule_strategy_execution_time_ms")).help("Execution time of schedule strategy in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._scheduleStrategyExecutionTime = (Summary.Child)this.scheduleStrategyExecutionTime.labels(this.metricsLabels);
        this.rebalanceTotalExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_rebalance_execution_time_total_ms")).help("Total execution time of a rebalance in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._rebalanceTotalExecutionTime = (Summary.Child)this.rebalanceTotalExecutionTime.labels(this.metricsLabels);
        this.rebalanceStrategyExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_rebalance_strategy_execution_time_ms")).help("Execution time of rebalance strategy in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._rebalanceStrategyExecutionTime = (Summary.Child)this.rebalanceStrategyExecutionTime.labels(this.metricsLabels);
        this.stopInstanceProcessTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_stop_instance_process_time_ms")).help("Stopping instance process time in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._stopInstanceProcessTime = (Summary.Child)this.stopInstanceProcessTime.labels(this.metricsLabels);
        this.startInstanceProcessTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_start_instance_process_time_ms")).help("Starting instance process time in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._startInstanceProcessTime = (Summary.Child)this.startInstanceProcessTime.labels(this.metricsLabels);
        this.drainTotalExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_worker_drain_execution_time_total_ms")).help("Total execution time of a drain in milliseconds.")).labelNames(metricsLabelNames)).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(1.0, 0.01).register(this.collectorRegistry);
        this._drainTotalExecutionTime = (Summary.Child)this.drainTotalExecutionTime.labels(this.metricsLabels);
        if (runAsStandalone) {
            ((Collector)Gauge.build("jvm_memory_direct_bytes_used", "-").create().setChild(new Gauge.Child(){

                @Override
                public double get() {
                    return JvmMetrics.getJvmDirectMemoryUsed();
                }
            }, new String[0])).register(CollectorRegistry.defaultRegistry);
            ((Collector)Gauge.build("jvm_memory_direct_bytes_max", "-").create().setChild(new Gauge.Child(){

                @Override
                public double get() {
                    return PlatformDependent.maxDirectMemory();
                }
            }, new String[0])).register(CollectorRegistry.defaultRegistry);
        }
    }

    public void startupTimeStart() {
        this.startupTimeStart = System.nanoTime();
    }

    public void startupTimeEnd() {
        if (this.startupTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.startupTimeStart.longValue()) / 1000000.0;
            this._statWorkerStartupTime.observe(endTimeMs);
        }
    }

    public void scheduleTotalExecTimeStart() {
        this.scheduleTotalExecTimeStart = System.nanoTime();
    }

    public void scheduleTotalExecTimeEnd() {
        if (this.scheduleTotalExecTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.scheduleTotalExecTimeStart.longValue()) / 1000000.0;
            this._scheduleTotalExecutionTime.observe(endTimeMs);
        }
    }

    public void scheduleStrategyExecTimeStartStart() {
        this.scheduleStrategyExecTimeStart = System.nanoTime();
    }

    public void scheduleStrategyExecTimeStartEnd() {
        if (this.scheduleStrategyExecTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.scheduleStrategyExecTimeStart.longValue()) / 1000000.0;
            this._scheduleStrategyExecutionTime.observe(endTimeMs);
        }
    }

    public void rebalanceTotalExecTimeStart() {
        this.rebalanceTotalExecTimeStart = System.nanoTime();
    }

    public void rebalanceTotalExecTimeEnd() {
        if (this.rebalanceTotalExecTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.rebalanceTotalExecTimeStart.longValue()) / 1000000.0;
            this._rebalanceTotalExecutionTime.observe(endTimeMs);
        }
    }

    public void rebalanceStrategyExecTimeStart() {
        this.rebalanceStrategyExecTimeStart = System.nanoTime();
    }

    public void rebalanceStrategyExecTimeEnd() {
        if (this.rebalanceStrategyExecTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.rebalanceStrategyExecTimeStart.longValue()) / 1000000.0;
            this._rebalanceStrategyExecutionTime.observe(endTimeMs);
        }
    }

    public void drainTotalExecTimeStart() {
        this.drainTotalExecTimeStart = System.nanoTime();
    }

    public void drainTotalExecTimeEnd() {
        if (this.drainTotalExecTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.drainTotalExecTimeStart.longValue()) / 1000000.0;
            this._drainTotalExecutionTime.observe(endTimeMs);
        }
    }

    public void stopInstanceProcessTimeStart() {
        this.stopInstanceProcessTimeStart = System.nanoTime();
    }

    public void stopInstanceProcessTimeEnd() {
        if (this.stopInstanceProcessTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.stopInstanceProcessTimeStart.longValue()) / 1000000.0;
            this._stopInstanceProcessTime.observe(endTimeMs);
        }
    }

    public void startInstanceProcessTimeStart() {
        this.startInstanceProcessTimeStart = System.nanoTime();
    }

    public void startInstanceProcessTimeEnd() {
        if (this.startInstanceProcessTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.startInstanceProcessTimeStart.longValue()) / 1000000.0;
            this._startInstanceProcessTime.observe(endTimeMs);
        }
    }

    public String getStatsAsString() throws IOException {
        this._statNumInstances.set(this.functionRuntimeManager.getMyInstances());
        StringWriter outputWriter = new StringWriter();
        PrometheusTextFormat.write004(outputWriter, this.collectorRegistry.metricFamilySamples());
        this.generateLeaderMetrics(outputWriter);
        return outputWriter.toString();
    }

    private void generateLeaderMetrics(StringWriter stream) {
        if (this.isLeader.get().booleanValue()) {
            List<Function.FunctionMetaData> metadata = this.functionMetaDataManager.getAllFunctionMetaData();
            long totalFunctions = metadata.size();
            this.writeMetric(TOTAL_FUNCTIONS_COUNT, totalFunctions, stream);
            long totalInstances = 0L;
            for (Function.FunctionMetaData entry : metadata) {
                totalInstances += (long)entry.getFunctionDetails().getParallelism();
            }
            this.writeMetric(TOTAL_EXPECTED_INSTANCE_COUNT, totalInstances, stream);
            this.writeMetric(IS_LEADER, 1L, stream);
        }
    }

    private void writeMetric(String metricName, long value, StringWriter stream) {
        stream.write("# TYPE ");
        stream.write(PULSAR_FUNCTION_WORKER_METRICS_PREFIX);
        stream.write(metricName);
        stream.write(" gauge");
        stream.write("\n");
        stream.write(PULSAR_FUNCTION_WORKER_METRICS_PREFIX);
        stream.write(metricName);
        stream.write("{");
        for (int i = 0; i < metricsLabelNames.length; ++i) {
            stream.write(metricsLabelNames[i]);
            stream.write(61);
            stream.write(34);
            stream.write(this.metricsLabels[i]);
            stream.write("\",");
        }
        stream.write(125);
        stream.write(32);
        stream.write(String.valueOf(value));
        stream.write(10);
    }

    public void setFunctionRuntimeManager(FunctionRuntimeManager functionRuntimeManager) {
        this.functionRuntimeManager = functionRuntimeManager;
    }

    public void setFunctionMetaDataManager(FunctionMetaDataManager functionMetaDataManager) {
        this.functionMetaDataManager = functionMetaDataManager;
    }

    public void setLeaderService(LeaderService leaderService) {
        this.leaderService = leaderService;
    }

    public void setIsLeader(Supplier<Boolean> isLeader) {
        this.isLeader = isLeader;
    }

    static {
        DefaultExports.initialize();
        metricsLabelNames = new String[]{"cluster"};
    }
}

