/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.google.api.client.http;

import java.io.IOException;
import org.apache.pulsar.shade.com.google.api.client.http.GenericUrl;
import org.apache.pulsar.shade.com.google.api.client.http.HttpContent;
import org.apache.pulsar.shade.com.google.api.client.http.HttpRequest;
import org.apache.pulsar.shade.com.google.api.client.http.HttpRequestInitializer;
import org.apache.pulsar.shade.com.google.api.client.http.HttpTransport;

public final class HttpRequestFactory {
    private final HttpTransport transport;
    private final HttpRequestInitializer initializer;

    HttpRequestFactory(HttpTransport transport, HttpRequestInitializer initializer) {
        this.transport = transport;
        this.initializer = initializer;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpRequestInitializer getInitializer() {
        return this.initializer;
    }

    public HttpRequest buildRequest(String requestMethod, GenericUrl url, HttpContent content) throws IOException {
        HttpRequest request = this.transport.buildRequest();
        if (url != null) {
            request.setUrl(url);
        }
        if (this.initializer != null) {
            this.initializer.initialize(request);
        }
        request.setRequestMethod(requestMethod);
        if (content != null) {
            request.setContent(content);
        }
        return request;
    }

    public HttpRequest buildDeleteRequest(GenericUrl url) throws IOException {
        return this.buildRequest("DELETE", url, null);
    }

    public HttpRequest buildGetRequest(GenericUrl url) throws IOException {
        return this.buildRequest("GET", url, null);
    }

    public HttpRequest buildPostRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest("POST", url, content);
    }

    public HttpRequest buildPutRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest("PUT", url, content);
    }

    public HttpRequest buildPatchRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest("PATCH", url, content);
    }

    public HttpRequest buildHeadRequest(GenericUrl url) throws IOException {
        return this.buildRequest("HEAD", url, null);
    }
}

