/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBookiesService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListBookiesService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;

    public ListBookiesService(ServerConfiguration conf, BookKeeperAdmin bka) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean printHostname;
            ArrayList<BookieId> bookies = new ArrayList<BookieId>();
            Map<String, String> params = request.getParams();
            boolean readOnly = params != null && params.containsKey("type") && params.get("type").equals("ro");
            boolean bl = printHostname = params != null && params.containsKey("print_hostnames") && params.get("print_hostnames").equals("true");
            if (readOnly) {
                bookies.addAll(this.bka.getReadOnlyBookies());
            } else {
                bookies.addAll(this.bka.getAvailableBookies());
            }
            HashMap<String, String> output = Maps.newHashMap();
            for (BookieId b : bookies) {
                String hostname = null;
                if (printHostname) {
                    BookieSocketAddress resolved = this.bka.getBookieAddressResolver().resolve(b);
                    hostname = resolved.getHostName();
                }
                output.putIfAbsent(b.toString(), hostname);
                LOG.debug("bookie: " + b.toString() + " hostname:" + hostname);
            }
            String jsonResponse = JsonUtil.toJson(output);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

