/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.transaction.buffer.TransactionEntry;
import org.apache.pulsar.client.api.transaction.TxnID;

public class TransactionEntryImpl
implements TransactionEntry {
    private final TxnID txnId;
    private final long sequenceId;
    private final long committedAtLedgerId;
    private final long committedAtEntryId;
    private final Entry entry;
    private final int numMessageInTxn;
    private int startBatchIndex;

    public TransactionEntryImpl(TxnID txnId, long sequenceId, Entry entry, long committedAtLedgerId, long committedAtEntryId, int numMessageInTxn) {
        this.txnId = txnId;
        this.sequenceId = sequenceId;
        this.entry = entry;
        this.committedAtLedgerId = committedAtLedgerId;
        this.committedAtEntryId = committedAtEntryId;
        this.numMessageInTxn = numMessageInTxn;
    }

    @Override
    public TxnID txnId() {
        return this.txnId;
    }

    @Override
    public long sequenceId() {
        return this.sequenceId;
    }

    @Override
    public int numMessageInTxn() {
        return this.numMessageInTxn;
    }

    @Override
    public long committedAtLedgerId() {
        return this.committedAtLedgerId;
    }

    @Override
    public long committedAtEntryId() {
        return this.committedAtEntryId;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    public void setStartBatchIndex(int startBatchIndex) {
        this.startBatchIndex = startBatchIndex;
    }

    public int getStartBatchIndex() {
        return this.startBatchIndex;
    }

    @Override
    public void close() {
        if (null != this.entry) {
            this.entry.getDataBuffer().release();
            this.entry.release();
        }
    }

    public byte[] getData() {
        return this.entry.getData();
    }

    public byte[] getDataAndRelease() {
        return this.entry.getDataAndRelease();
    }

    public int getLength() {
        return this.entry.getLength();
    }

    public ByteBuf getDataBuffer() {
        return this.entry.getDataBuffer();
    }

    public Position getPosition() {
        return this.entry.getPosition();
    }

    public long getLedgerId() {
        return this.committedAtLedgerId;
    }

    public long getEntryId() {
        return this.committedAtEntryId;
    }

    public boolean release() {
        return this.entry.release();
    }
}

