/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.tls.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConnectionController {
    public State increaseConnection(SocketAddress var1);

    public void decreaseConnection(SocketAddress var1);

    public static class DefaultConnectionController
    implements ConnectionController {
        private static final Logger log = LoggerFactory.getLogger(DefaultConnectionController.class);
        private static final Map<String, MutableInt> CONNECTIONS = new HashMap<String, MutableInt>();
        private static final ReentrantLock lock = new ReentrantLock();
        private static int totalConnectionNum = 0;
        private final int maxConnections;
        private final int maxConnectionPerIp;
        private final boolean maxConnectionsLimitEnabled;
        private final boolean maxConnectionsLimitPerIpEnabled;

        public DefaultConnectionController(ServiceConfiguration configuration) {
            this.maxConnections = configuration.getBrokerMaxConnections();
            this.maxConnectionPerIp = configuration.getBrokerMaxConnectionsPerIp();
            this.maxConnectionsLimitEnabled = configuration.getBrokerMaxConnections() > 0;
            this.maxConnectionsLimitPerIpEnabled = configuration.getBrokerMaxConnectionsPerIp() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State increaseConnection(SocketAddress remoteAddress) {
            if (!this.maxConnectionsLimitEnabled && !this.maxConnectionsLimitPerIpEnabled) {
                return State.OK;
            }
            if (!(remoteAddress instanceof InetSocketAddress) || !this.isLegalIpAddress(((InetSocketAddress)remoteAddress).getHostString())) {
                return State.OK;
            }
            lock.lock();
            try {
                String ip = ((InetSocketAddress)remoteAddress).getHostString();
                if (this.maxConnectionsLimitPerIpEnabled) {
                    CONNECTIONS.computeIfAbsent(ip, x -> new MutableInt(0)).increment();
                }
                if (this.maxConnectionsLimitEnabled) {
                    ++totalConnectionNum;
                }
                if (this.maxConnectionsLimitEnabled && totalConnectionNum > this.maxConnections) {
                    log.info("Reject connect request from {}, because reached the maximum number of connections {}", (Object)remoteAddress, (Object)totalConnectionNum);
                    State state = State.REACH_MAX_CONNECTION;
                    return state;
                }
                if (this.maxConnectionsLimitPerIpEnabled && CONNECTIONS.get(ip).getValue() > this.maxConnectionPerIp) {
                    log.info("Reject connect request from {}, because reached the maximum number of connections per Ip {}", (Object)remoteAddress, (Object)CONNECTIONS.get(ip).getValue());
                    State state = State.REACH_MAX_CONNECTION_PER_IP;
                    return state;
                }
            }
            catch (Exception e) {
                log.error("increase connection failed", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
            return State.OK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void decreaseConnection(SocketAddress remoteAddress) {
            if (!this.maxConnectionsLimitEnabled && !this.maxConnectionsLimitPerIpEnabled) {
                return;
            }
            if (!(remoteAddress instanceof InetSocketAddress) || !this.isLegalIpAddress(((InetSocketAddress)remoteAddress).getHostString())) {
                return;
            }
            lock.lock();
            try {
                String ip = ((InetSocketAddress)remoteAddress).getHostString();
                MutableInt mutableInt = CONNECTIONS.get(ip);
                if (this.maxConnectionsLimitPerIpEnabled && mutableInt != null && mutableInt.decrementAndGet() <= 0) {
                    CONNECTIONS.remove(ip);
                }
                if (this.maxConnectionsLimitEnabled) {
                    --totalConnectionNum;
                }
            }
            finally {
                lock.unlock();
            }
        }

        private boolean isLegalIpAddress(String address) {
            return InetAddressUtils.isIPv4Address((String)address) || InetAddressUtils.isIPv6Address((String)address);
        }
    }

    public static enum State {
        OK,
        REACH_MAX_CONNECTION_PER_IP,
        REACH_MAX_CONNECTION;

    }
}

