/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.broker.web.RequestWrapper;
import org.apache.pulsar.common.intercept.InterceptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInterceptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PreInterceptFilter.class);
    private final BrokerInterceptor interceptor;
    private final ExceptionHandler exceptionHandler;

    public PreInterceptFilter(BrokerInterceptor interceptor, ExceptionHandler exceptionHandler) {
        this.interceptor = interceptor;
        this.exceptionHandler = exceptionHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("PreInterceptFilter: path {}, type {}", (Object)servletRequest.getServletContext().getContextPath(), (Object)servletRequest.getContentType());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)servletRequest.getContentType(), (CharSequence)"multipart/form-data") || StringUtils.containsIgnoreCase((CharSequence)servletRequest.getContentType(), (CharSequence)"application/octet-stream")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest)servletRequest);
            if (this.interceptor != null) {
                this.interceptor.onWebserviceRequest((ServletRequest)requestWrapper);
            }
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        }
        catch (InterceptException e) {
            this.exceptionHandler.handle(servletResponse, (Exception)((Object)e));
        }
    }

    public void destroy() {
    }
}

