/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
    private boolean generateDocs = false;
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);

    public PulsarStandaloneStarter(String[] args) throws Exception {
        String[] metadataStoreUrl;
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.isHelp() || StringUtils.isBlank((CharSequence)this.getConfigFile())) {
                jcommander.usage();
                return;
            }
            if (this.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("standalone", (Object)this);
                cmd.run(null);
                System.exit(0);
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            log.error(e.getMessage());
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(this.getConfigFile());){
            this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)inputStream, ServiceConfiguration.class);
        }
        String zkServers = "127.0.0.1";
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
            zkServers = this.getAdvertisedAddress();
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress()) && StringUtils.isBlank((CharSequence)this.config.getAdvertisedListeners())) {
            this.config.setAdvertisedAddress("localhost");
        }
        if (!PulsarStandaloneStarter.argsContains(args, "--zookeeper-port") && StringUtils.isNotBlank((CharSequence)this.config.getMetadataStoreUrl())) {
            metadataStoreUrl = this.config.getMetadataStoreUrl().split(",")[0].split(":");
            if (metadataStoreUrl.length == 2) {
                this.setZkPort(Integer.parseInt(metadataStoreUrl[1]));
            } else if (metadataStoreUrl.length == 3) {
                String zkPort = metadataStoreUrl[2];
                if (zkPort.contains("/")) {
                    this.setZkPort(Integer.parseInt(zkPort.substring(0, zkPort.lastIndexOf("/"))));
                } else {
                    this.setZkPort(Integer.parseInt(zkPort));
                }
            }
        }
        metadataStoreUrl = "zk:" + zkServers + ":" + this.getZkPort();
        this.config.setMetadataStoreUrl((String)metadataStoreUrl);
        this.config.setConfigurationMetadataStoreUrl((String)metadataStoreUrl);
        this.config.setRunningStandalone(true);
        this.config.getProperties().setProperty("metadataStoreUrl", (String)metadataStoreUrl);
        this.config.getProperties().setProperty("configurationMetadataStoreUrl", (String)metadataStoreUrl);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (this.fnWorkerService != null) {
                    this.fnWorkerService.stop();
                }
                if (this.broker != null) {
                    this.broker.close();
                }
                if (this.bkEnsemble != null) {
                    this.bkEnsemble.stop();
                }
                LogManager.shutdown();
            }
            catch (Exception e) {
                log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }));
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        try {
            standalone.start();
        }
        catch (Throwable th) {
            log.error("Failed to start pulsar service.", th);
            LogManager.shutdown();
            Runtime.getRuntime().exit(1);
        }
    }
}

