/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.concurrent.atomic.AtomicBoolean;

class SchemaRegistryStats
implements AutoCloseable {
    private static final String SCHEMA_ID = "schema";
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final Counter getOpsFailedCounter;
    private final Counter putOpsFailedCounter;
    private final Counter deleteOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_del_ops_failed_count", (String)"-").labelNames(new String[]{"schema"})).create().register();
    private final Counter compatibleCounter;
    private final Counter incompatibleCounter;
    private final Summary deleteOpsLatency;
    private final Summary getOpsLatency;
    private final Summary putOpsLatency;
    private static volatile SchemaRegistryStats instance;

    static synchronized SchemaRegistryStats getInstance() {
        if (null == instance) {
            instance = new SchemaRegistryStats();
        }
        return instance;
    }

    private SchemaRegistryStats() {
        this.getOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_get_ops_failed_count", (String)"-").labelNames(new String[]{SCHEMA_ID})).create().register();
        this.putOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_put_ops_failed_count", (String)"-").labelNames(new String[]{SCHEMA_ID})).create().register();
        this.compatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_compatible_count", (String)"-").labelNames(new String[]{SCHEMA_ID})).create().register();
        this.incompatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_incompatible_count", (String)"-").labelNames(new String[]{SCHEMA_ID})).create().register();
        this.deleteOpsLatency = this.buildSummary("pulsar_schema_del_ops_latency", "-");
        this.getOpsLatency = this.buildSummary("pulsar_schema_get_ops_latency", "-");
        this.putOpsLatency = this.buildSummary("pulsar_schema_put_ops_latency", "-");
    }

    private Summary buildSummary(String name, String help) {
        Summary.Builder builder = (Summary.Builder)Summary.build((String)name, (String)help).labelNames(new String[]{SCHEMA_ID});
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.create().register();
    }

    void recordDelFailed(String schemaId) {
        ((Counter.Child)this.deleteOpsFailedCounter.labels(new String[]{schemaId})).inc();
    }

    void recordGetFailed(String schemaId) {
        ((Counter.Child)this.getOpsFailedCounter.labels(new String[]{schemaId})).inc();
    }

    void recordPutFailed(String schemaId) {
        ((Counter.Child)this.putOpsFailedCounter.labels(new String[]{schemaId})).inc();
    }

    void recordDelLatency(String schemaId, long millis) {
        ((Summary.Child)this.deleteOpsLatency.labels(new String[]{schemaId})).observe((double)millis);
    }

    void recordGetLatency(String schemaId, long millis) {
        ((Summary.Child)this.getOpsLatency.labels(new String[]{schemaId})).observe((double)millis);
    }

    void recordPutLatency(String schemaId, long millis) {
        ((Summary.Child)this.putOpsLatency.labels(new String[]{schemaId})).observe((double)millis);
    }

    void recordSchemaIncompatible(String schemaId) {
        ((Counter.Child)this.incompatibleCounter.labels(new String[]{schemaId})).inc();
    }

    void recordSchemaCompatible(String schemaId) {
        ((Counter.Child)this.compatibleCounter.labels(new String[]{schemaId})).inc();
    }

    @Override
    public void close() throws Exception {
        if (CLOSED.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.deleteOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.getOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.putOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.compatibleCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.incompatibleCounter);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.deleteOpsLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.getOpsLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.putOpsLatency);
        }
    }
}

