/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import org.apache.pulsar.broker.stats.WindowWrap;

public final class TimeWindow<T> {
    private final int interval;
    private final int sampleCount;
    private final AtomicReferenceArray<WindowWrap<T>> array;

    public TimeWindow(int sampleCount, int interval) {
        this.sampleCount = sampleCount;
        this.interval = interval;
        this.array = new AtomicReferenceArray(sampleCount);
    }

    public synchronized WindowWrap<T> current(Function<T, T> function) {
        WindowWrap<T> old;
        long millis = System.currentTimeMillis();
        if (millis < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(millis);
        long windowStart = this.calculateWindowStart(millis);
        while ((old = this.array.get(idx)) == null) {
            WindowWrap<Object> window = new WindowWrap<Object>(this.interval, windowStart, null);
            if (this.array.compareAndSet(idx, null, window)) {
                Object value = null == function ? null : (Object)function.apply(null);
                window.value(value);
                return window;
            }
            Thread.yield();
        }
        if (windowStart == old.start()) {
            return old;
        }
        if (windowStart > old.start()) {
            Object value = null == function ? null : (Object)function.apply(old.value());
            old.value(value);
            old.resetWindowStart(windowStart);
            return old;
        }
        throw new IllegalStateException();
    }

    private int calculateTimeIdx(long timeMillis) {
        long timeId = timeMillis / (long)this.interval;
        return (int)(timeId % (long)this.sampleCount);
    }

    private long calculateWindowStart(long timeMillis) {
        return timeMillis - timeMillis % (long)this.interval;
    }

    public int sampleCount() {
        return this.sampleCount;
    }

    public int interval() {
        return this.interval;
    }

    public long currentWindowStart(long millis) {
        return this.calculateWindowStart(millis);
    }
}

