/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;

public class WebExecutorStats
implements AutoCloseable {
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final Gauge maxThreads;
    private final Gauge minThreads;
    private final Gauge idleThreads;
    private final Gauge activeThreads;
    private final Gauge currentThreads;
    private final WebExecutorThreadPool executor;
    private static volatile WebExecutorStats instance;

    static synchronized WebExecutorStats getStats(WebExecutorThreadPool executor) {
        if (null == instance) {
            instance = new WebExecutorStats(executor);
        }
        return instance;
    }

    private WebExecutorStats(WebExecutorThreadPool executor) {
        this.executor = executor;
        this.maxThreads = (Gauge)Gauge.build((String)"pulsar_web_executor_max_threads", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return WebExecutorStats.this.executor.getMaxThreads();
            }
        }, new String[0]).register();
        this.minThreads = (Gauge)Gauge.build((String)"pulsar_web_executor_min_threads", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return WebExecutorStats.this.executor.getMinThreads();
            }
        }, new String[0]).register();
        this.idleThreads = (Gauge)Gauge.build((String)"pulsar_web_executor_idle_threads", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return WebExecutorStats.this.executor.getIdleThreads();
            }
        }, new String[0]).register();
        this.activeThreads = (Gauge)Gauge.build((String)"pulsar_web_executor_active_threads", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return WebExecutorStats.this.executor.getThreads() - WebExecutorStats.this.executor.getIdleThreads();
            }
        }, new String[0]).register();
        this.currentThreads = (Gauge)Gauge.build((String)"pulsar_web_executor_current_threads", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return WebExecutorStats.this.executor.getThreads();
            }
        }, new String[0]).register();
    }

    @Override
    public void close() throws Exception {
        if (CLOSED.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.activeThreads);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.maxThreads);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.minThreads);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.idleThreads);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.currentThreads);
        }
    }
}

