/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;

public record ServiceUnitStateData(ServiceUnitState state, String dstBroker, String sourceBroker, Map<String, Optional<String>> splitServiceUnitToDestBroker, boolean force, long timestamp, long versionId) {
    public ServiceUnitStateData {
        Objects.requireNonNull(state);
        if (StringUtils.isBlank((CharSequence)dstBroker) && StringUtils.isBlank((CharSequence)sourceBroker)) {
            throw new IllegalArgumentException("Empty broker");
        }
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, String sourceBroker, Map<String, Optional<String>> splitServiceUnitToDestBroker, long versionId) {
        this(state, dstBroker, sourceBroker, splitServiceUnitToDestBroker, false, System.currentTimeMillis(), versionId);
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, String sourceBroker, Map<String, Optional<String>> splitServiceUnitToDestBroker, boolean force, long versionId) {
        this(state, dstBroker, sourceBroker, splitServiceUnitToDestBroker, force, System.currentTimeMillis(), versionId);
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, String sourceBroker, long versionId) {
        this(state, dstBroker, sourceBroker, null, false, System.currentTimeMillis(), versionId);
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, String sourceBroker, boolean force, long versionId) {
        this(state, dstBroker, sourceBroker, null, force, System.currentTimeMillis(), versionId);
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, long versionId) {
        this(state, dstBroker, null, null, false, System.currentTimeMillis(), versionId);
    }

    public ServiceUnitStateData(ServiceUnitState state, String dstBroker, boolean force, long versionId) {
        this(state, dstBroker, null, null, force, System.currentTimeMillis(), versionId);
    }

    public static ServiceUnitState state(ServiceUnitStateData data) {
        return data == null ? ServiceUnitState.Init : data.state();
    }
}

