/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.policies;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolationPoliciesHelper {
    private static final Logger log = LoggerFactory.getLogger(IsolationPoliciesHelper.class);
    private final SimpleResourceAllocationPolicies policies;

    public IsolationPoliciesHelper(SimpleResourceAllocationPolicies policies) {
        this.policies = policies;
    }

    public CompletableFuture<Set<String>> applyIsolationPoliciesAsync(final Map<String, BrokerLookupData> availableBrokers, ServiceUnitId serviceUnit) {
        return LoadManagerShared.applyNamespacePoliciesAsync(serviceUnit, this.policies, availableBrokers.keySet(), new LoadManagerShared.BrokerTopicLoadingPredicate(){

            @Override
            public boolean isEnablePersistentTopics(String brokerUrl) {
                BrokerLookupData lookupData = (BrokerLookupData)availableBrokers.get(brokerUrl.replace("http://", ""));
                return lookupData != null && lookupData.persistentTopicsEnabled();
            }

            @Override
            public boolean isEnableNonPersistentTopics(String brokerUrl) {
                BrokerLookupData lookupData = (BrokerLookupData)availableBrokers.get(brokerUrl.replace("http://", ""));
                return lookupData != null && lookupData.nonPersistentTopicsEnabled();
            }
        });
    }

    public boolean hasIsolationPolicy(NamespaceName namespaceName) {
        return this.policies.areIsolationPoliciesPresent(namespaceName);
    }
}

