/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculator;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQuotaCalculatorImpl
implements ResourceQuotaCalculator {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotaCalculatorImpl.class);

    @Override
    public long computeLocalQuota(long confUsage, long myUsage, long[] allUsages) throws PulsarAdminException {
        String errMesg;
        if (confUsage < 0L) {
            int retVal = -1;
            if (log.isDebugEnabled()) {
                log.debug("Configured usage ({}) is not set; returning a special value ({}) for calculated quota", (Object)confUsage, (Object)-1);
            }
            return -1L;
        }
        long totalUsage = 0L;
        for (long usage : allUsages) {
            totalUsage += usage;
        }
        if (myUsage < 0L || totalUsage < 0L) {
            errMesg = String.format("Local usage (%d) or total usage (%d) is negative", myUsage, totalUsage);
            log.error(errMesg);
            throw new PulsarAdminException(errMesg);
        }
        if (totalUsage == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("computeLocalQuota: totalUsage is zero; returning the configured usage ({}) as new local quota", (Object)confUsage);
            }
            return confUsage;
        }
        if (myUsage > totalUsage) {
            errMesg = String.format("Local usage (%d) is greater than total usage (%d)", myUsage, totalUsage);
            log.warn(errMesg);
        }
        float residual = confUsage - totalUsage;
        float myUsageFraction = (float)myUsage / (float)totalUsage;
        float calculatedQuota = Float.max((float)myUsage + residual * myUsageFraction, 1.0f);
        long longCalculatedQuota = (long)calculatedQuota;
        log.info("computeLocalQuota: myUsage={}, totalUsage={}, myFraction={}; newQuota returned={} [long: {}]", new Object[]{myUsage, totalUsage, Float.valueOf(myUsageFraction), Float.valueOf(calculatedQuota), longCalculatedQuota});
        return longCalculatedQuota;
    }

    @Override
    public boolean needToReportLocalUsage(long currentBytesUsed, long lastReportedBytes, long currentMessagesUsed, long lastReportedMessages, long lastReportTimeMSecsSinceEpoch) {
        long diff;
        float diffPercentage;
        long currentTimeMSecs = System.currentTimeMillis();
        long mSecsSinceLastReport = currentTimeMSecs - lastReportTimeMSecsSinceEpoch;
        if (mSecsSinceLastReport >= ResourceGroupService.maxIntervalForSuppressingReportsMSecs) {
            return true;
        }
        float toleratedDriftPercentage = 5.0f;
        if (currentBytesUsed > 0L && (diffPercentage = (float)(diff = Math.abs(currentBytesUsed - lastReportedBytes)) * 100.0f / (float)lastReportedBytes) > 5.0f) {
            return true;
        }
        return currentMessagesUsed > 0L && (diffPercentage = (float)(diff = Math.abs(currentMessagesUsed - lastReportedMessages)) * 100.0f / (float)lastReportedMessages) > 5.0f;
    }
}

