/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.api.proto.IntRange;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.util.FutureUtil;

public class HashRangeExclusiveStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private final int rangeSize;
    private final ConcurrentSkipListMap<Integer, Consumer> rangeMap;

    public HashRangeExclusiveStickyKeyConsumerSelector() {
        this(65536);
    }

    public HashRangeExclusiveStickyKeyConsumerSelector(int rangeSize) {
        if (rangeSize < 1) {
            throw new IllegalArgumentException("range size must greater than 0");
        }
        this.rangeSize = rangeSize;
        this.rangeMap = new ConcurrentSkipListMap();
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        return this.validateKeySharedMeta(consumer).thenRun(() -> {
            try {
                this.internalAddConsumer(consumer);
            }
            catch (BrokerServiceException.ConsumerAssignException e) {
                throw FutureUtil.wrapToCompletionException((Throwable)e);
            }
        });
    }

    private synchronized void internalAddConsumer(Consumer consumer) throws BrokerServiceException.ConsumerAssignException {
        Consumer conflictingConsumer = this.findConflictingConsumer(consumer.getKeySharedMeta().getHashRangesList());
        if (conflictingConsumer != null) {
            throw new BrokerServiceException.ConsumerAssignException("Range conflict with consumer " + conflictingConsumer);
        }
        for (IntRange intRange : consumer.getKeySharedMeta().getHashRangesList()) {
            this.rangeMap.put(intRange.getStart(), consumer);
            this.rangeMap.put(intRange.getEnd(), consumer);
        }
    }

    @Override
    public void removeConsumer(Consumer consumer) {
        this.rangeMap.entrySet().removeIf(entry -> ((Consumer)entry.getValue()).equals(consumer));
    }

    @Override
    public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        HashMap<Consumer, List<Range>> result = new HashMap<Consumer, List<Range>>();
        Map.Entry<Integer, Consumer> prev = null;
        for (Map.Entry<Integer, Consumer> entry : this.rangeMap.entrySet()) {
            if (prev == null) {
                prev = entry;
                continue;
            }
            if (prev.getValue().equals(entry.getValue())) {
                result.computeIfAbsent(entry.getValue(), key -> new ArrayList()).add(Range.of((int)prev.getKey(), (int)entry.getKey()));
            }
            prev = null;
        }
        return result;
    }

    @Override
    public Consumer select(int hash) {
        if (this.rangeMap.size() > 0) {
            Consumer floorConsumer;
            int slot = hash % this.rangeSize;
            Map.Entry<Integer, Consumer> ceilingEntry = this.rangeMap.ceilingEntry(slot);
            Map.Entry<Integer, Consumer> floorEntry = this.rangeMap.floorEntry(slot);
            Consumer ceilingConsumer = ceilingEntry != null ? ceilingEntry.getValue() : null;
            Consumer consumer = floorConsumer = floorEntry != null ? floorEntry.getValue() : null;
            if (floorConsumer != null && floorConsumer.equals(ceilingConsumer)) {
                return ceilingConsumer;
            }
            return null;
        }
        return null;
    }

    private synchronized CompletableFuture<Void> validateKeySharedMeta(Consumer consumer) {
        if (consumer.getKeySharedMeta() == null) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Must specify key shared meta for consumer."));
        }
        List ranges = consumer.getKeySharedMeta().getHashRangesList();
        if (ranges.isEmpty()) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Ranges for KeyShared policy must not be empty."));
        }
        for (IntRange intRange : ranges) {
            if (intRange.getStart() <= intRange.getEnd()) continue;
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Fixed hash range start > end"));
        }
        Consumer conflictingConsumer = this.findConflictingConsumer(ranges);
        if (conflictingConsumer != null) {
            return conflictingConsumer.cnx().checkConnectionLiveness().thenRun(() -> {});
        }
        return CompletableFuture.completedFuture(null);
    }

    private synchronized Consumer findConflictingConsumer(List<IntRange> ranges) {
        for (IntRange intRange : ranges) {
            Map.Entry<Integer, Consumer> ceilingEntry = this.rangeMap.ceilingEntry(intRange.getStart());
            Map.Entry<Integer, Consumer> floorEntry = this.rangeMap.floorEntry(intRange.getEnd());
            if (floorEntry != null && floorEntry.getKey() >= intRange.getStart()) {
                return floorEntry.getValue();
            }
            if (ceilingEntry != null && ceilingEntry.getKey() <= intRange.getEnd()) {
                return ceilingEntry.getValue();
            }
            if (ceilingEntry == null || floorEntry == null || !ceilingEntry.getValue().equals(floorEntry.getValue())) continue;
            KeySharedMeta keySharedMeta = ceilingEntry.getValue().getKeySharedMeta();
            for (IntRange range : keySharedMeta.getHashRangesList()) {
                int start = Math.max(intRange.getStart(), range.getStart());
                int end = Math.min(intRange.getEnd(), range.getEnd());
                if (end < start) continue;
                return ceilingEntry.getValue();
            }
        }
        return null;
    }

    Map<Integer, Consumer> getRangeConsumer() {
        return Collections.unmodifiableMap(this.rangeMap);
    }
}

