/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.protocol.Commands;

public class RawBatchConverter {
    public static boolean isReadableBatch(RawMessage msg) {
        ByteBuf payload = msg.getHeadersAndPayload();
        MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        return RawBatchConverter.isReadableBatch(metadata);
    }

    public static boolean isReadableBatch(MessageMetadata metadata) {
        return metadata.hasNumMessagesInBatch() && metadata.getEncryptionKeysCount() == 0;
    }

    public static List<ImmutableTriple<MessageId, String, Integer>> extractIdsAndKeysAndSize(RawMessage msg) throws IOException {
        return RawBatchConverter.extractIdsAndKeysAndSize(msg, true);
    }

    public static List<ImmutableTriple<MessageId, String, Integer>> extractIdsAndKeysAndSize(RawMessage msg, boolean extractNullKey) throws IOException {
        Preconditions.checkArgument((msg.getMessageIdData().getBatchIndex() == -1 ? 1 : 0) != 0);
        ByteBuf payload = msg.getHeadersAndPayload();
        MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        int batchSize = metadata.getNumMessagesInBatch();
        CompressionType compressionType = metadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((CompressionType)compressionType);
        int uncompressedSize = metadata.getUncompressedSize();
        ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
        ArrayList<ImmutableTriple<MessageId, String, Integer>> idsAndKeysAndSize = new ArrayList<ImmutableTriple<MessageId, String, Integer>>();
        SingleMessageMetadata smm = new SingleMessageMetadata();
        for (int i = 0; i < batchSize; ++i) {
            ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)uncompressedPayload, (SingleMessageMetadata)smm, (int)0, (int)batchSize);
            BatchMessageIdImpl id = new BatchMessageIdImpl(msg.getMessageIdData().getLedgerId(), msg.getMessageIdData().getEntryId(), msg.getMessageIdData().getPartition(), i);
            if (!smm.isCompactedOut() && (extractNullKey || smm.hasPartitionKey())) {
                idsAndKeysAndSize.add((ImmutableTriple<MessageId, String, Integer>)ImmutableTriple.of((Object)id, (Object)(smm.hasPartitionKey() ? smm.getPartitionKey() : null), (Object)(smm.hasPayloadSize() ? smm.getPayloadSize() : 0)));
            }
            singleMessagePayload.release();
        }
        uncompressedPayload.release();
        return idsAndKeysAndSize;
    }

    public static Optional<RawMessage> rebatchMessage(RawMessage msg, BiPredicate<String, MessageId> filter) throws IOException {
        return RawBatchConverter.rebatchMessage(msg, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<RawMessage> rebatchMessage(RawMessage msg, BiPredicate<String, MessageId> filter, boolean retainNullKey) throws IOException {
        Preconditions.checkArgument((msg.getMessageIdData().getBatchIndex() == -1 ? 1 : 0) != 0);
        ByteBuf payload = msg.getHeadersAndPayload();
        int readerIndex = payload.readerIndex();
        ByteBuf brokerMeta = null;
        if (payload.getShort(readerIndex) == 3586) {
            payload.skipBytes(2);
            int brokerEntryMetadataSize = payload.readInt();
            payload.readerIndex(readerIndex);
            brokerMeta = payload.readSlice(brokerEntryMetadataSize + 2 + 4);
        }
        MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        ByteBuf batchBuffer = PulsarByteBufAllocator.DEFAULT.buffer(payload.capacity());
        CompressionType compressionType = metadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((CompressionType)compressionType);
        int uncompressedSize = metadata.getUncompressedSize();
        ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
        try {
            int batchSize = metadata.getNumMessagesInBatch();
            int messagesRetained = 0;
            SingleMessageMetadata emptyMetadata = new SingleMessageMetadata().setCompactedOut(true);
            SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
            for (int i = 0; i < batchSize; ++i) {
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)uncompressedPayload, (SingleMessageMetadata)singleMessageMetadata, (int)0, (int)batchSize);
                BatchMessageIdImpl id = new BatchMessageIdImpl(msg.getMessageIdData().getLedgerId(), msg.getMessageIdData().getEntryId(), msg.getMessageIdData().getPartition(), i);
                if (!singleMessageMetadata.hasPartitionKey()) {
                    if (retainNullKey) {
                        ++messagesRetained;
                        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)singleMessageMetadata, (ByteBuf)singleMessagePayload, (ByteBuf)batchBuffer);
                    } else {
                        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)emptyMetadata, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
                    }
                } else if (filter.test(singleMessageMetadata.getPartitionKey(), (MessageId)id) && singleMessagePayload.readableBytes() > 0) {
                    ++messagesRetained;
                    Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)singleMessageMetadata, (ByteBuf)singleMessagePayload, (ByteBuf)batchBuffer);
                } else {
                    Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)emptyMetadata, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
                }
                singleMessagePayload.release();
            }
            if (messagesRetained > 0) {
                int newUncompressedSize = batchBuffer.readableBytes();
                ByteBuf compressedPayload = codec.encode(batchBuffer);
                metadata.setUncompressedSize(newUncompressedSize);
                ByteBuf metadataAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.Crc32c, (MessageMetadata)metadata, (ByteBuf)compressedPayload);
                if (brokerMeta != null) {
                    CompositeByteBuf compositeByteBuf = PulsarByteBufAllocator.DEFAULT.compositeDirectBuffer();
                    compositeByteBuf.addComponents(true, new ByteBuf[]{brokerMeta.retain(), metadataAndPayload});
                    metadataAndPayload = compositeByteBuf;
                }
                Optional<RawMessage> result = Optional.of(new RawMessageImpl(msg.getMessageIdData(), metadataAndPayload));
                metadataAndPayload.release();
                compressedPayload.release();
                Optional<RawMessage> optional = result;
                return optional;
            }
            Optional<RawMessage> optional = Optional.empty();
            return optional;
        }
        finally {
            uncompressedPayload.release();
            batchBuffer.release();
        }
    }
}

