/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherSingleActiveConsumer;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.TopicCompactionService;

public class CompactedTopicUtils {
    public static void asyncReadCompactedEntries(TopicCompactionService topicCompactionService, ManagedCursor cursor, int maxEntries, long bytesToRead, boolean readFromEarliest, AsyncCallbacks.ReadEntriesCallback callback, boolean wait, @Nullable Consumer consumer) {
        CompactedTopicUtils.asyncReadCompactedEntries(topicCompactionService, cursor, maxEntries, bytesToRead, PositionImpl.LATEST, readFromEarliest, callback, wait, consumer);
    }

    @Beta
    public static void asyncReadCompactedEntries(TopicCompactionService topicCompactionService, ManagedCursor cursor, int maxEntries, long bytesToRead, PositionImpl maxReadPosition, boolean readFromEarliest, AsyncCallbacks.ReadEntriesCallback callback, boolean wait, @Nullable Consumer consumer) {
        Objects.requireNonNull(topicCompactionService);
        Objects.requireNonNull(cursor);
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0);
        Objects.requireNonNull(callback);
        PositionImpl readPosition = readFromEarliest ? PositionImpl.EARLIEST : (PositionImpl)cursor.getReadPosition();
        PersistentDispatcherSingleActiveConsumer.ReadEntriesCtx readEntriesCtx = PersistentDispatcherSingleActiveConsumer.ReadEntriesCtx.create(consumer, -1L);
        CompletableFuture<Position> lastCompactedPositionFuture = topicCompactionService.getLastCompactedPosition();
        ((CompletableFuture)lastCompactedPositionFuture.thenCompose(lastCompactedPosition -> {
            if (lastCompactedPosition == null || readPosition.compareTo(lastCompactedPosition.getLedgerId(), lastCompactedPosition.getEntryId()) > 0) {
                if (wait) {
                    cursor.asyncReadEntriesOrWait(maxEntries, bytesToRead, callback, (Object)readEntriesCtx, maxReadPosition);
                } else {
                    cursor.asyncReadEntries(maxEntries, bytesToRead, callback, (Object)readEntriesCtx, maxReadPosition);
                }
                return CompletableFuture.completedFuture(null);
            }
            ManagedCursorImpl managedCursor = (ManagedCursorImpl)cursor;
            int numberOfEntriesToRead = managedCursor.applyMaxSizeCap(maxEntries, bytesToRead);
            return topicCompactionService.readCompactedEntries((Position)readPosition, numberOfEntriesToRead).thenAccept(entries -> {
                if (CollectionUtils.isEmpty((Collection)entries)) {
                    Position seekToPosition = lastCompactedPosition.getNext();
                    if (readPosition.compareTo(seekToPosition.getLedgerId(), seekToPosition.getEntryId()) > 0) {
                        seekToPosition = readPosition;
                    }
                    cursor.seek(seekToPosition);
                    callback.readEntriesComplete(Collections.emptyList(), (Object)readEntriesCtx);
                    return;
                }
                long entriesSize = 0L;
                for (Entry entry : entries) {
                    entriesSize += (long)entry.getLength();
                }
                managedCursor.updateReadStats(entries.size(), entriesSize);
                Entry lastEntry = (Entry)entries.get(entries.size() - 1);
                cursor.seek(lastEntry.getPosition().getNext(), true);
                callback.readEntriesComplete(entries, (Object)readEntriesCtx);
            });
        })).exceptionally(exception -> {
            ManagedLedgerException managedLedgerException = (exception = FutureUtil.unwrapCompletionException((Throwable)exception)) instanceof ManagedLedgerException ? (ManagedLedgerException)((Object)exception) : new ManagedLedgerException(exception);
            callback.readEntriesFailed(managedLedgerException, (Object)readEntriesCtx);
            return null;
        });
    }
}

