/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.ResourceGroups;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class ResourceGroupsImpl
extends BaseResource
implements ResourceGroups {
    private final WebTarget adminResourceGroups;

    public ResourceGroupsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminResourceGroups = web.path("/admin/v2/resourcegroups");
    }

    public List<String> getResourceGroups() throws PulsarAdminException {
        try {
            return this.getResourceGroupsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> getResourceGroupsAsync() {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(this.adminResourceGroups, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> resourcegroups) {
                future.complete(resourcegroups);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ResourceGroupsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public ResourceGroup getResourceGroup(String resourcegroup) throws PulsarAdminException {
        try {
            return this.getResourceGroupAsync(resourcegroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<ResourceGroup> getResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        final CompletableFuture<ResourceGroup> future = new CompletableFuture<ResourceGroup>();
        this.asyncGetRequest(path, new InvocationCallback<ResourceGroup>(){

            @Override
            public void completed(ResourceGroup resourcegroup) {
                future.complete(resourcegroup);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(ResourceGroupsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        try {
            this.createResourceGroupAsync(name, resourcegroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity(resourcegroup, "application/json"));
    }

    public void updateResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        try {
            this.getResourceGroup(name);
            this.updateResourceGroupAsync(name, resourcegroup).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | RestException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity(resourcegroup, "application/json"));
    }

    public void deleteResourceGroup(String name) throws PulsarAdminException {
        try {
            this.deleteResourceGroupAsync(name).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncDeleteRequest(path);
    }
}

