/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;

public class TopicPoliciesImpl
extends BaseResource
implements TopicPolicies {
    private final WebTarget adminTopics;
    private final WebTarget adminV2Topics;
    private final boolean isGlobal;

    protected TopicPoliciesImpl(WebTarget web, Authentication auth, long readTimeoutMs, boolean isGlobal) {
        super(auth, readTimeoutMs);
        this.adminTopics = web.path("/admin");
        this.adminV2Topics = web.path("/admin/v2");
        this.isGlobal = isGlobal;
    }

    public WebTarget addGlobalIfNeeded(WebTarget path) {
        return this.isGlobal ? path.queryParam("isGlobal", true) : path;
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic) throws PulsarAdminException {
        return this.getBacklogQuotaMap(topic, false);
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuotaMap");
            path = path.queryParam("applied", applied);
            return this.request(path).get(new GenericType<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void setBacklogQuota(String topic, BacklogQuota backlogQuota) throws PulsarAdminException {
        super.setBacklogQuota(topic, backlogQuota);
    }

    public void removeBacklogQuota(String topic) throws PulsarAdminException {
        super.removeBacklogQuota(topic);
    }

    public void setBacklogQuota(String topic, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", backlogQuotaType.toString())).post(Entity.entity(backlogQuota, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void removeBacklogQuota(String topic, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", backlogQuotaType.toString())).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnConsumer(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic) {
        return this.getMaxUnackedMessagesOnConsumerAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getMaxUnackedMessagesOnConsumerAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxNum) {
                future.complete(maxNum);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnConsumerAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxNum), "application/json"));
    }

    public void setMaxUnackedMessagesOnConsumer(String topic, int maxNum) throws PulsarAdminException {
        try {
            this.setMaxUnackedMessagesOnConsumerAsync(topic, maxNum).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnConsumerAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncDeleteRequest(path);
    }

    public void removeMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        try {
            this.removeMaxUnackedMessagesOnConsumerAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getInactiveTopicPoliciesAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        path = path.queryParam("applied", applied);
        final CompletableFuture<InactiveTopicPolicies> future = new CompletableFuture<InactiveTopicPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<InactiveTopicPolicies>(){

            @Override
            public void completed(InactiveTopicPolicies inactiveTopicPolicies) {
                future.complete(inactiveTopicPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic) throws PulsarAdminException {
        return this.getInactiveTopicPolicies(topic, false);
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic) {
        return this.getInactiveTopicPoliciesAsync(topic, false);
    }

    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String topic, InactiveTopicPolicies inactiveTopicPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity(inactiveTopicPolicies, "application/json"));
    }

    public void setInactiveTopicPolicies(String topic, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        try {
            this.setInactiveTopicPoliciesAsync(topic, inactiveTopicPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    public void removeInactiveTopicPolicies(String topic) throws PulsarAdminException {
        try {
            this.removeInactiveTopicPoliciesAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getDelayedDeliveryPolicyAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        path = path.queryParam("applied", applied);
        final CompletableFuture<DelayedDeliveryPolicies> future = new CompletableFuture<DelayedDeliveryPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<DelayedDeliveryPolicies>(){

            @Override
            public void completed(DelayedDeliveryPolicies delayedDeliveryPolicies) {
                future.complete(delayedDeliveryPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        return this.getDelayedDeliveryPolicy(topic, false);
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic) {
        return this.getDelayedDeliveryPolicyAsync(topic, false);
    }

    public CompletableFuture<Void> removeDelayedDeliveryPolicyAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    public void removeDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        try {
            this.removeDelayedDeliveryPolicyAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDelayedDeliveryPolicyAsync(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity(delayedDeliveryPolicies, "application/json"));
    }

    public void setDelayedDeliveryPolicy(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        try {
            this.setDelayedDeliveryPolicyAsync(topic, delayedDeliveryPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public Boolean getDeduplicationStatus(String topic) throws PulsarAdminException {
        return this.getDeduplicationStatus(topic, false);
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic) {
        return this.getDeduplicationStatusAsync(topic, false);
    }

    public Boolean getDeduplicationStatus(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getDeduplicationStatusAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enabled) {
                future.complete(enabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    private CompletableFuture<Void> enableDeduplicationAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enabled), "application/json"));
    }

    public void setDeduplicationStatus(String topic, boolean enabled) throws PulsarAdminException {
        try {
            this.enableDeduplicationAsync(topic, enabled).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDeduplicationStatusAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enabled), "application/json"));
    }

    public void removeDeduplicationStatus(String topic) throws PulsarAdminException {
        try {
            this.removeDeduplicationStatusAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDeduplicationStatusAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationEnabled");
        return this.asyncDeleteRequest(path);
    }

    public OffloadPolicies getOffloadPolicies(String topic) throws PulsarAdminException {
        return this.getOffloadPolicies(topic, false);
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic) {
        return this.getOffloadPoliciesAsync(topic, false);
    }

    public OffloadPolicies getOffloadPolicies(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getOffloadPoliciesAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        path = path.queryParam("applied", applied);
        final CompletableFuture<OffloadPolicies> future = new CompletableFuture<OffloadPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<OffloadPoliciesImpl>(){

            @Override
            public void completed(OffloadPoliciesImpl offloadPolicies) {
                future.complete(offloadPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setOffloadPolicies(String topic, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        try {
            this.setOffloadPoliciesAsync(topic, offloadPolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setOffloadPoliciesAsync(String topic, OffloadPolicies offloadPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity((OffloadPoliciesImpl)offloadPolicies, "application/json"));
    }

    public void removeOffloadPolicies(String topic) throws PulsarAdminException {
        try {
            this.removeOffloadPoliciesAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeOffloadPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnSubscription(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        return this.getMaxUnackedMessagesOnSubscriptionAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getMaxUnackedMessagesOnSubscriptionAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxNum) {
                future.complete(maxNum);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxUnackedMessagesOnSubscription(String topic, int maxNum) throws PulsarAdminException {
        try {
            this.setMaxUnackedMessagesOnSubscriptionAsync(topic, maxNum).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnSubscriptionAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxNum), "application/json"));
    }

    public void removeMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        try {
            this.removeMaxUnackedMessagesOnSubscriptionAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncDeleteRequest(path);
    }

    public void setMessageTTL(String topic, int messageTTLInSecond) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", messageTTLInSecond)).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public Integer getMessageTTL(String topic) throws PulsarAdminException {
        return this.getMessageTTL(topic, false);
    }

    public Integer getMessageTTL(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            path = path.queryParam("applied", applied);
            return this.request(path).get(new GenericType<Integer>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void removeMessageTTL(String topic) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", 0)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public void setRetention(String topic, RetentionPolicies retention) throws PulsarAdminException {
        try {
            this.setRetentionAsync(topic, retention).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setRetentionAsync(String topic, RetentionPolicies retention) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncPostRequest(path, Entity.entity(retention, "application/json"));
    }

    public RetentionPolicies getRetention(String topic) throws PulsarAdminException {
        return this.getRetention(topic, false);
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic) {
        return this.getRetentionAsync(topic, false);
    }

    public RetentionPolicies getRetention(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getRetentionAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        path = path.queryParam("applied", applied);
        final CompletableFuture<RetentionPolicies> future = new CompletableFuture<RetentionPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<RetentionPolicies>(){

            @Override
            public void completed(RetentionPolicies retentionPolicies) {
                future.complete(retentionPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removeRetention(String topic) throws PulsarAdminException {
        try {
            this.removeRetentionAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeRetentionAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncDeleteRequest(path);
    }

    public void setPersistence(String topic, PersistencePolicies persistencePolicies) throws PulsarAdminException {
        try {
            this.setPersistenceAsync(topic, persistencePolicies).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setPersistenceAsync(String topic, PersistencePolicies persistencePolicies) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncPostRequest(path, Entity.entity(persistencePolicies, "application/json"));
    }

    public PersistencePolicies getPersistence(String topic) throws PulsarAdminException {
        return this.getPersistence(topic, false);
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic) {
        return this.getPersistenceAsync(topic, false);
    }

    public PersistencePolicies getPersistence(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getPersistenceAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        path = path.queryParam("applied", applied);
        final CompletableFuture<PersistencePolicies> future = new CompletableFuture<PersistencePolicies>();
        this.asyncGetRequest(path, new InvocationCallback<PersistencePolicies>(){

            @Override
            public void completed(PersistencePolicies persistencePolicies) {
                future.complete(persistencePolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void removePersistence(String topic) throws PulsarAdminException {
        try {
            this.removePersistenceAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removePersistenceAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getDispatchRateAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        path = path.queryParam("applied", applied);
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DispatchRate getDispatchRate(String topic) throws PulsarAdminException {
        return this.getDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic) {
        return this.getDispatchRateAsync(topic, false);
    }

    public void setDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setDispatchRateAsync(topic, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeDispatchRate(String topic) throws PulsarAdminException {
        try {
            this.removeDispatchRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getSubscriptionDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getSubscriptionDispatchRateAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        path = path.queryParam("applied", applied);
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public DispatchRate getSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        return this.getSubscriptionDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic) {
        return this.getSubscriptionDispatchRateAsync(topic, false);
    }

    public void setSubscriptionDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setSubscriptionDispatchRateAsync(topic, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        try {
            this.removeSubscriptionDispatchRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public Long getCompactionThreshold(String topic) throws PulsarAdminException {
        return this.getCompactionThreshold(topic, false);
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic) {
        return this.getCompactionThresholdAsync(topic, false);
    }

    public Long getCompactionThreshold(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getCompactionThresholdAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long compactionThreshold) {
                future.complete(compactionThreshold);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setCompactionThreshold(String topic, long compactionThreshold) throws PulsarAdminException {
        try {
            this.setCompactionThresholdAsync(topic, compactionThreshold).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setCompactionThresholdAsync(String topic, long compactionThreshold) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncPostRequest(path, Entity.entity(Long.valueOf(compactionThreshold), "application/json"));
    }

    public void removeCompactionThreshold(String topic) throws PulsarAdminException {
        try {
            this.removeCompactionThresholdAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeCompactionThresholdAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    public PublishRate getPublishRate(String topic) throws PulsarAdminException {
        try {
            return this.getPublishRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<PublishRate> getPublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        final CompletableFuture<PublishRate> future = new CompletableFuture<PublishRate>();
        this.asyncGetRequest(path, new InvocationCallback<PublishRate>(){

            @Override
            public void completed(PublishRate publishRate) {
                future.complete(publishRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setPublishRate(String topic, PublishRate publishRate) throws PulsarAdminException {
        try {
            this.setPublishRateAsync(topic, publishRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setPublishRateAsync(String topic, PublishRate publishRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncPostRequest(path, Entity.entity(publishRate, "application/json"));
    }

    public void removePublishRate(String topic) throws PulsarAdminException {
        try {
            this.removePublishRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removePublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        try {
            return this.getMaxConsumersPerSubscriptionAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxConsumersPerSubscription) {
                future.complete(maxConsumersPerSubscription);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumersPerSubscription(String topic, int maxConsumersPerSubscription) throws PulsarAdminException {
        try {
            this.setMaxConsumersPerSubscriptionAsync(topic, maxConsumersPerSubscription).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String topic, int maxConsumersPerSubscription) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"));
    }

    public void removeMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        try {
            this.removeMaxConsumersPerSubscriptionAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxProducers(String topic) throws PulsarAdminException {
        return this.getMaxProducers(topic, false);
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic) {
        return this.getMaxProducersAsync(topic, false);
    }

    public Integer getMaxProducers(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getMaxProducersAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxProducers) {
                future.complete(maxProducers);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxProducers(String topic, int maxProducers) throws PulsarAdminException {
        try {
            this.setMaxProducersAsync(topic, maxProducers).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxProducersAsync(String topic, int maxProducers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxProducers), "application/json"));
    }

    public void removeMaxProducers(String topic) throws PulsarAdminException {
        try {
            this.removeMaxProducersAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxProducersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        try {
            return this.getMaxSubscriptionsPerTopicAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxSubscriptionsPerTopic) {
                future.complete(maxSubscriptionsPerTopic);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxSubscriptionsPerTopic(String topic, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        try {
            this.setMaxSubscriptionsPerTopicAsync(topic, maxSubscriptionsPerTopic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String topic, int maxSubscriptionsPerTopic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxSubscriptionsPerTopic), "application/json"));
    }

    public void removeMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        try {
            this.removeMaxSubscriptionsPerTopicAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxMessageSize(String topic) throws PulsarAdminException {
        try {
            return this.getMaxMessageSizeAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxMessageSize) {
                future.complete(maxMessageSize);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxMessageSize(String topic, int maxMessageSize) throws PulsarAdminException {
        try {
            this.setMaxMessageSizeAsync(topic, maxMessageSize).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxMessageSizeAsync(String topic, int maxMessageSize) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxMessageSize), "application/json"));
    }

    public void removeMaxMessageSize(String topic) throws PulsarAdminException {
        try {
            this.removeMaxMessageSizeAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumers(String topic) throws PulsarAdminException {
        return this.getMaxConsumers(topic, false);
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic) {
        return this.getMaxConsumersAsync(topic, false);
    }

    public Integer getMaxConsumers(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getMaxConsumersAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxProducers) {
                future.complete(maxProducers);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setMaxConsumers(String topic, int maxConsumers) throws PulsarAdminException {
        try {
            this.setMaxConsumersAsync(topic, maxConsumers).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setMaxConsumersAsync(String topic, int maxConsumers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumers), "application/json"));
    }

    public void removeMaxConsumers(String topic) throws PulsarAdminException {
        try {
            this.removeMaxConsumersAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeMaxConsumersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        try {
            return this.getDeduplicationSnapshotIntervalAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationSnapshotInterval");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer interval) {
                future.complete(interval);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setDeduplicationSnapshotInterval(String topic, int interval) throws PulsarAdminException {
        try {
            this.setDeduplicationSnapshotIntervalAsync(topic, interval).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String topic, int interval) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(interval), "application/json"));
    }

    public void removeDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        try {
            this.removeDeduplicationSnapshotIntervalAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionTypesEnabled(String topic, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        try {
            this.setSubscriptionTypesEnabledAsync(topic, subscriptionTypesEnabled).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String topic, Set<SubscriptionType> subscriptionTypesEnabled) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypesEnabled, "application/json"));
    }

    public Set<SubscriptionType> getSubscriptionTypesEnabled(String topic) throws PulsarAdminException {
        try {
            return this.getSubscriptionTypesEnabledAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionTypesEnabled");
        final CompletableFuture<Set<SubscriptionType>> future = new CompletableFuture<Set<SubscriptionType>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<SubscriptionType>>(){

            @Override
            public void completed(Set<SubscriptionType> subscriptionTypesEnabled) {
                future.complete(subscriptionTypesEnabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SubscribeRate getSubscribeRate(String topic) throws PulsarAdminException {
        return this.getSubscribeRate(topic, false);
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic) {
        return this.getSubscribeRateAsync(topic, false);
    }

    public SubscribeRate getSubscribeRate(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getSubscribeRateAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        path = path.queryParam("applied", applied);
        final CompletableFuture<SubscribeRate> future = new CompletableFuture<SubscribeRate>();
        this.asyncGetRequest(path, new InvocationCallback<SubscribeRate>(){

            @Override
            public void completed(SubscribeRate subscribeRate) {
                future.complete(subscribeRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setSubscribeRate(String topic, SubscribeRate subscribeRate) throws PulsarAdminException {
        try {
            this.setSubscribeRateAsync(topic, subscribeRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setSubscribeRateAsync(String topic, SubscribeRate subscribeRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity(subscribeRate, "application/json"));
    }

    public void removeSubscribeRate(String topic) throws PulsarAdminException {
        try {
            this.removeSubscribeRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeSubscribeRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getReplicatorDispatchRate(String topic) throws PulsarAdminException {
        return this.getReplicatorDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic) {
        return this.getReplicatorDispatchRateAsync(topic, false);
    }

    public DispatchRate getReplicatorDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        try {
            return this.getReplicatorDispatchRateAsync(topic, applied).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "replicatorDispatchRate");
        path = path.queryParam("applied", applied);
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TopicPoliciesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void setReplicatorDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        try {
            this.setReplicatorDispatchRateAsync(topic, dispatchRate).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeReplicatorDispatchRate(String topic) throws PulsarAdminException {
        try {
            this.removeReplicatorDispatchRateAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    private TopicName validateTopic(String topic) {
        return TopicName.get(topic);
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2Topics : this.adminTopics;
        WebTarget topicPath = base.path(topic.getRestPath());
        topicPath = WebTargets.addParts(topicPath, parts);
        topicPath = this.addGlobalIfNeeded(topicPath);
        return topicPath;
    }
}

