/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Properties;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class TenantsImpl
extends BaseResource
implements Tenants,
Properties {
    private final WebTarget adminTenants;

    public TenantsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminTenants = web.path("/admin/v2/tenants");
    }

    @Override
    public List<String> getTenants() throws PulsarAdminException {
        try {
            return this.getTenantsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<String>> getTenantsAsync() {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(this.adminTenants, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> tenants) {
                future.complete(tenants);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TenantsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public TenantInfo getTenantInfo(String tenant) throws PulsarAdminException {
        try {
            return this.getTenantInfoAsync(tenant).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<TenantInfo> getTenantInfoAsync(String tenant) {
        WebTarget path = this.adminTenants.path(tenant);
        final CompletableFuture<TenantInfo> future = new CompletableFuture<TenantInfo>();
        this.asyncGetRequest(path, new InvocationCallback<TenantInfoImpl>(){

            @Override
            public void completed(TenantInfoImpl tenantInfo) {
                future.complete(tenantInfo);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TenantsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        try {
            this.createTenantAsync(tenant, config).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> createTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPutRequest(path, Entity.entity(config, "application/json"));
    }

    @Override
    public void updateTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        try {
            this.updateTenantAsync(tenant, config).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPostRequest(path, Entity.entity((TenantInfoImpl)config, "application/json"));
    }

    @Override
    public void deleteTenant(String tenant) throws PulsarAdminException {
        try {
            this.deleteTenantAsync(tenant).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public void deleteTenant(String tenant, boolean force) throws PulsarAdminException {
        try {
            this.deleteTenantAsync(tenant, force).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteTenantAsync(String tenant) {
        return this.deleteTenantAsync(tenant, false);
    }

    @Override
    public CompletableFuture<Void> deleteTenantAsync(String tenant, boolean force) {
        WebTarget path = this.adminTenants.path(tenant);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void createProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.createTenant(tenant, config);
    }

    @Override
    public void updateProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.updateTenant(tenant, config);
    }

    @Override
    public void deleteProperty(String tenant) throws PulsarAdminException {
        this.deleteTenant(tenant);
    }

    @Override
    public List<String> getProperties() throws PulsarAdminException {
        return this.getTenants();
    }

    @Override
    public TenantInfo getPropertyAdmin(String tenant) throws PulsarAdminException {
        return this.getTenantInfo(tenant);
    }

    public WebTarget getWebTarget() {
        return this.adminTenants;
    }
}

