/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pulsar.client.impl;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class ProducerResponse {
    private String producerName;
    private long lastSequenceId;
    private byte[] schemaVersion;

    private Optional<Long> topicEpoch;

    // Shadow the default getter generated by lombok. In broker, if the schema version is an empty byte array, it means
    // the topic doesn't have schema.
    public byte[] getSchemaVersion() {
        if (schemaVersion != null && schemaVersion.length != 0) {
            return schemaVersion;
        } else {
            return null;
        }
    }
}
