/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final PulsarClientImpl client;
    private final TransactionCoordinatorClientImpl transactionCoordinatorClient;
    private long txnTimeout = 60000L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public TransactionBuilderImpl(PulsarClientImpl client, TransactionCoordinatorClientImpl tcClient) {
        this.client = client;
        this.transactionCoordinatorClient = tcClient;
    }

    public TransactionBuilder withTransactionTimeout(long txnTimeout, TimeUnit timeoutUnit) {
        this.txnTimeout = txnTimeout;
        this.timeUnit = timeoutUnit;
        return this;
    }

    public CompletableFuture<Transaction> build() {
        CompletableFuture<Transaction> future = new CompletableFuture<Transaction>();
        this.transactionCoordinatorClient.newTransactionAsync(this.txnTimeout, this.timeUnit).whenComplete((txnID, throwable) -> {
            if (log.isDebugEnabled()) {
                log.debug("Success to new txn. txnID: {}", txnID);
            }
            if (throwable != null) {
                log.error("New transaction error.", throwable);
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            TransactionImpl transaction = new TransactionImpl(this.client, this.timeUnit.toMillis(this.txnTimeout), txnID.getLeastSigBits(), txnID.getMostSigBits());
            future.complete(transaction);
        });
        return future;
    }
}

