/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public class ChunkMessageIdImpl
extends MessageIdImpl
implements MessageId {
    private final MessageIdImpl firstChunkMsgId;

    public ChunkMessageIdImpl(MessageIdImpl firstChunkMsgId, MessageIdImpl lastChunkMsgId) {
        super(lastChunkMsgId.getLedgerId(), lastChunkMsgId.getEntryId(), lastChunkMsgId.getPartitionIndex());
        this.firstChunkMsgId = firstChunkMsgId;
    }

    public MessageIdImpl getFirstChunkMessageId() {
        return this.firstChunkMsgId;
    }

    public MessageIdImpl getLastChunkMessageId() {
        return this;
    }

    @Override
    public String toString() {
        return this.firstChunkMsgId.toString() + ';' + super.toString();
    }

    @Override
    public byte[] toByteArray() {
        MessageIdData msgId = super.writeMessageIdData(null, -1, 0);
        msgId.setFirstChunkMessageId();
        this.firstChunkMsgId.writeMessageIdData(msgId.getFirstChunkMessageId(), -1, 0);
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer(size, size);
        msgId.writeTo(serialized);
        return serialized.array();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.firstChunkMsgId.hashCode());
    }
}

