/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.GenericObjectWrapper;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConsumeSchema
implements org.apache.pulsar.client.api.Schema<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AutoConsumeSchema.class);
    private final ConcurrentMap<SchemaVersion, org.apache.pulsar.client.api.Schema<?>> schemaMap = this.initSchemaMap();
    private String topicName;
    private String componentName;
    private SchemaInfoProvider schemaInfoProvider;

    private ConcurrentMap<SchemaVersion, org.apache.pulsar.client.api.Schema<?>> initSchemaMap() {
        ConcurrentMap<SchemaVersion, org.apache.pulsar.client.api.Schema<?>> schemaMap = Maps.newConcurrentMap();
        schemaMap.put(BytesSchemaVersion.of(new byte[0]), org.apache.pulsar.client.api.Schema.BYTES);
        return schemaMap;
    }

    public void setSchema(SchemaVersion schemaVersion, org.apache.pulsar.client.api.Schema<?> schema) {
        this.schemaMap.put(schemaVersion, schema);
    }

    public void setSchema(org.apache.pulsar.client.api.Schema<?> schema) {
        this.schemaMap.put(SchemaVersion.Latest, schema);
    }

    private void ensureSchemaInitialized(SchemaVersion schemaVersion) {
        Preconditions.checkState(this.schemaMap.containsKey(schemaVersion), "Schema version " + schemaVersion + " is not initialized before used");
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized(SchemaVersion.Latest);
        ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(SchemaVersion.Latest)).validate(message);
    }

    public void validate(byte[] message, byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.ensureSchemaInitialized(sv);
        ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(sv)).validate(message);
    }

    public byte[] encode(GenericRecord message) {
        throw new UnsupportedOperationException("AutoConsumeSchema is not intended to be used for encoding");
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    public org.apache.pulsar.client.api.Schema<?> atSchemaVersion(byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.fetchSchemaIfNeeded(sv);
        this.ensureSchemaInitialized(sv);
        org.apache.pulsar.client.api.Schema topicVersionedSchema = (org.apache.pulsar.client.api.Schema)this.schemaMap.get(sv);
        if (topicVersionedSchema.supportSchemaVersioning() && topicVersionedSchema instanceof AbstractSchema) {
            return ((AbstractSchema)topicVersionedSchema).atSchemaVersion(schemaVersion);
        }
        return topicVersionedSchema;
    }

    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.fetchSchemaIfNeeded(sv);
        this.ensureSchemaInitialized(sv);
        return this.adapt(((org.apache.pulsar.client.api.Schema)this.schemaMap.get(sv)).decode(bytes, schemaVersion), schemaVersion);
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
        for (org.apache.pulsar.client.api.Schema schema : this.schemaMap.values()) {
            schema.setSchemaInfoProvider(schemaInfoProvider);
        }
    }

    public SchemaInfo getSchemaInfo() {
        if (!this.schemaMap.containsKey(SchemaVersion.Latest)) {
            return null;
        }
        return ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(SchemaVersion.Latest)).getSchemaInfo();
    }

    public SchemaInfo getSchemaInfo(byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        if (this.schemaMap.containsKey(sv)) {
            return ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(sv)).getSchemaInfo();
        }
        return null;
    }

    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        this.topicName = topicName;
        this.componentName = componentName;
        if (schemaInfo != null) {
            org.apache.pulsar.client.api.Schema<?> genericSchema = AutoConsumeSchema.generateSchema(schemaInfo);
            this.setSchema(SchemaVersion.Latest, genericSchema);
            log.info("Configure {} schema for topic {} : {}", new Object[]{componentName, topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    public Optional<Object> getNativeSchema() {
        this.ensureSchemaInitialized(SchemaVersion.Latest);
        if (this.schemaMap.get(SchemaVersion.Latest) == null) {
            return Optional.empty();
        }
        return ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(SchemaVersion.Latest)).getNativeSchema();
    }

    private static org.apache.pulsar.client.api.Schema<?> generateSchema(SchemaInfo schemaInfo) {
        boolean useProvidedSchemaAsReaderSchema = false;
        switch (schemaInfo.getType()) {
            case JSON: 
            case AVRO: {
                return AutoConsumeSchema.extractFromAvroSchema(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo, false);
            }
        }
        return AutoConsumeSchema.getSchema(schemaInfo);
    }

    private static org.apache.pulsar.client.api.Schema<?> extractFromAvroSchema(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        Schema avroSchema = SchemaUtil.parseAvroSchema(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        if (avroSchema.getType() == Schema.Type.RECORD) {
            return GenericSchemaImpl.of(schemaInfo, useProvidedSchemaAsReaderSchema);
        }
        if (schemaInfo.getType() == SchemaType.JSON) {
            return org.apache.pulsar.client.api.Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(ReflectData.get().getClass(avroSchema)).build());
        }
        return org.apache.pulsar.client.api.Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withJsonDef(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8)).build());
    }

    public static org.apache.pulsar.client.api.Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case BYTES: 
            case NONE: {
                return BytesSchema.of();
            }
            case DATE: {
                return DateSchema.of();
            }
            case TIME: {
                return TimeSchema.of();
            }
            case TIMESTAMP: {
                return TimestampSchema.of();
            }
            case INSTANT: {
                return InstantSchema.of();
            }
            case LOCAL_DATE: {
                return LocalDateSchema.of();
            }
            case LOCAL_TIME: {
                return LocalTimeSchema.of();
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeSchema.of();
            }
            case JSON: 
            case AVRO: {
                return GenericSchemaImpl.of(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
                org.apache.pulsar.client.api.Schema<?> keySchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getKey());
                org.apache.pulsar.client.api.Schema<?> valueSchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getValue());
                return KeyValueSchemaImpl.of(keySchema, valueSchema, KeyValueSchemaInfo.decodeKeyValueEncodingType(schemaInfo));
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + schemaInfo.getType() + "' is not supported yet");
    }

    public org.apache.pulsar.client.api.Schema<GenericRecord> clone() {
        AutoConsumeSchema schema = new AutoConsumeSchema();
        schema.configureSchemaInfo(this.topicName, this.componentName, null);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        for (Map.Entry entry : this.schemaMap.entrySet()) {
            schema.setSchema((SchemaVersion)entry.getKey(), (org.apache.pulsar.client.api.Schema)entry.getValue());
        }
        return schema;
    }

    public boolean requireFetchingSchemaInfo() {
        return true;
    }

    protected GenericRecord adapt(Object value, byte[] schemaVersion) {
        if (value instanceof GenericRecord) {
            return (GenericRecord)value;
        }
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        if (!this.schemaMap.containsKey(sv)) {
            throw new IllegalStateException("Cannot decode a message without schema");
        }
        return AutoConsumeSchema.wrapPrimitiveObject(value, ((org.apache.pulsar.client.api.Schema)this.schemaMap.get(sv)).getSchemaInfo().getType(), schemaVersion);
    }

    public static GenericRecord wrapPrimitiveObject(Object value, SchemaType type, byte[] schemaVersion) {
        return GenericObjectWrapper.of(value, type, schemaVersion);
    }

    public org.apache.pulsar.client.api.Schema<?> getInternalSchema() {
        return (org.apache.pulsar.client.api.Schema)this.schemaMap.get(SchemaVersion.Latest);
    }

    public org.apache.pulsar.client.api.Schema<?> getInternalSchema(byte[] schemaVersion) {
        return (org.apache.pulsar.client.api.Schema)this.schemaMap.get(AutoConsumeSchema.getSchemaVersion(schemaVersion));
    }

    public void fetchSchemaIfNeeded(SchemaVersion schemaVersion) throws SchemaSerializationException {
        if (schemaVersion == null) {
            schemaVersion = BytesSchemaVersion.of(new byte[0]);
        }
        if (!this.schemaMap.containsKey(schemaVersion)) {
            if (this.schemaInfoProvider == null) {
                throw new SchemaSerializationException("Can't get accurate schema information for topic " + this.topicName + "using AutoConsumeSchema because SchemaInfoProvider is not set yet");
            }
            SchemaInfo schemaInfo = null;
            try {
                schemaInfo = (SchemaInfo)this.schemaInfoProvider.getSchemaByVersion(schemaVersion.bytes()).get();
                if (schemaInfo == null) {
                    schemaInfo = BytesSchema.of().getSchemaInfo();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("Can't get last schema for topic {} using AutoConsumeSchema", (Object)this.topicName);
                throw new SchemaSerializationException(e.getCause());
            }
            org.apache.pulsar.client.api.Schema<?> schema = AutoConsumeSchema.generateSchema(schemaInfo);
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
            this.setSchema(schemaVersion, schema);
            log.info("Configure {} schema {} for topic {} : {}", new Object[]{this.componentName, schemaVersion, this.topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    private static SchemaVersion getSchemaVersion(byte[] schemaVersion) {
        if (schemaVersion != null) {
            return BytesSchemaVersion.of(schemaVersion);
        }
        return BytesSchemaVersion.of(new byte[0]);
    }

    public String toString() {
        if (this.schemaMap.isEmpty()) {
            return "AUTO_CONSUME(uninitialized)";
        }
        StringBuilder sb = new StringBuilder("AUTO_CONSUME(");
        for (Map.Entry entry : this.schemaMap.entrySet()) {
            sb.append("{schemaVersion=").append(entry.getKey()).append(",schemaType=").append(((org.apache.pulsar.client.api.Schema)entry.getValue()).getSchemaInfo().getType()).append("}");
        }
        sb.append(")");
        return sb.toString();
    }
}

