package org.apache.pulsar.common.api.proto;
public final class CommandWatchTopicListSuccess {
	private long requestId;
	private static final int _REQUEST_ID_FIELD_NUMBER = 1;
	private static final int _REQUEST_ID_TAG = (_REQUEST_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_REQUEST_ID_TAG);
	private static final int _REQUEST_ID_MASK = 1 << (0 % 32);
	public boolean hasRequestId() {
		return (_bitField0 & _REQUEST_ID_MASK) != 0;
	}
	public long getRequestId() {
		if (!hasRequestId()) {
			throw new IllegalStateException("Field 'request_id' is not set");
		}
		return requestId;
	}
	public CommandWatchTopicListSuccess setRequestId(long requestId) {
		this.requestId = requestId;
		_bitField0 |= _REQUEST_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicListSuccess clearRequestId() {
		_bitField0 &= ~_REQUEST_ID_MASK;
		return this;
	}

	private long watcherId;
	private static final int _WATCHER_ID_FIELD_NUMBER = 2;
	private static final int _WATCHER_ID_TAG = (_WATCHER_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _WATCHER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_WATCHER_ID_TAG);
	private static final int _WATCHER_ID_MASK = 1 << (1 % 32);
	public boolean hasWatcherId() {
		return (_bitField0 & _WATCHER_ID_MASK) != 0;
	}
	public long getWatcherId() {
		if (!hasWatcherId()) {
			throw new IllegalStateException("Field 'watcher_id' is not set");
		}
		return watcherId;
	}
	public CommandWatchTopicListSuccess setWatcherId(long watcherId) {
		this.watcherId = watcherId;
		_bitField0 |= _WATCHER_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicListSuccess clearWatcherId() {
		_bitField0 &= ~_WATCHER_ID_MASK;
		return this;
	}

	private java.util.List<LightProtoCodec.StringHolder> topics = null;
	private int _topicsCount = 0;
	private static final int _TOPIC_FIELD_NUMBER = 3;
	private static final int _TOPIC_TAG = (_TOPIC_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPIC_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPIC_TAG);
	public int getTopicsCount() {
		return _topicsCount;
	}
	public String getTopicAt(int idx) {
		if (idx < 0 || idx >= _topicsCount) {
			throw new IndexOutOfBoundsException(
					"Index " + idx + " is out of the list size (" + _topicsCount + ") for field 'topic'");
		}
		LightProtoCodec.StringHolder _sh = topics.get(idx);
		if (_sh.s == null) {
			_sh.s = LightProtoCodec.readString(_parsedBuffer, _sh.idx, _sh.len);
		}
		return _sh.s;
	}
	public java.util.List<String> getTopicsList() {
		if (_topicsCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			java.util.List<String> _l = new java.util.ArrayList<>();
			for (int i = 0; i < _topicsCount; i++) {
				_l.add(getTopicAt(i));
			}
			return _l;
		}
	}
	public void addTopic(String topic) {
		if (topics == null) {
			topics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh = _newTopicStringHolder();
		_cachedSize = -1;
		_sh.s = topic;
		_sh.idx = -1;
		_sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
	}
	public CommandWatchTopicListSuccess addAllTopics(Iterable<String> topics) {
		for (String _s : topics) {
			addTopic(_s);
		}
		return this;
	}
	private LightProtoCodec.StringHolder _newTopicStringHolder() {
		if (topics == null) {
			topics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh;
		if (topics.size() == _topicsCount) {
			_sh = new LightProtoCodec.StringHolder();
			topics.add(_sh);
		} else {
			_sh = topics.get(_topicsCount);
		}
		_topicsCount++;
		return _sh;
	}
	public CommandWatchTopicListSuccess clearTopic() {
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_topicsCount = 0;
		return this;
	}

	private String topicsHash;
	private int _topicsHashBufferIdx = -1;
	private int _topicsHashBufferLen = -1;
	private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
	private static final int _TOPICS_HASH_TAG = (_TOPICS_HASH_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_HASH_TAG);
	private static final int _TOPICS_HASH_MASK = 1 << (3 % 32);
	public boolean hasTopicsHash() {
		return (_bitField0 & _TOPICS_HASH_MASK) != 0;
	}
	public String getTopicsHash() {
		if (!hasTopicsHash()) {
			throw new IllegalStateException("Field 'topics_hash' is not set");
		}
		if (topicsHash == null) {
			topicsHash = LightProtoCodec.readString(_parsedBuffer, _topicsHashBufferIdx, _topicsHashBufferLen);
		}
		return topicsHash;
	}
	public CommandWatchTopicListSuccess setTopicsHash(String topicsHash) {
		this.topicsHash = topicsHash;
		_bitField0 |= _TOPICS_HASH_MASK;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicListSuccess clearTopicsHash() {
		_bitField0 &= ~_TOPICS_HASH_MASK;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _REQUEST_ID_MASK | _WATCHER_ID_MASK | _TOPICS_HASH_MASK;
	public int writeTo(io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _REQUEST_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, requestId);
		LightProtoCodec.writeVarInt(_b, _WATCHER_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, watcherId);
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			LightProtoCodec.writeVarInt(_b, _TOPIC_TAG);
			LightProtoCodec.writeVarInt(_b, _sh.len);
			if (_sh.idx == -1) {
				LightProtoCodec.writeString(_b, _sh.s, _sh.len);
			} else {
				_parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
			}
		}
		LightProtoCodec.writeVarInt(_b, _TOPICS_HASH_TAG);
		LightProtoCodec.writeVarInt(_b, _topicsHashBufferLen);
		if (_topicsHashBufferIdx == -1) {
			LightProtoCodec.writeString(_b, topicsHash, _topicsHashBufferLen);
		} else {
			_parsedBuffer.getBytes(_topicsHashBufferIdx, _b, _topicsHashBufferLen);
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _REQUEST_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(requestId);
		_size += _WATCHER_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(watcherId);
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_size += _TOPIC_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
		}
		_size += _TOPICS_HASH_TAG_SIZE;
		_size += LightProtoCodec.computeVarIntSize(_topicsHashBufferLen);
		_size += _topicsHashBufferLen;
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _REQUEST_ID_TAG :
					_bitField0 |= _REQUEST_ID_MASK;
					requestId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _WATCHER_ID_TAG :
					_bitField0 |= _WATCHER_ID_MASK;
					watcherId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _TOPIC_TAG :
					LightProtoCodec.StringHolder _topicSh = _newTopicStringHolder();
					_topicSh.len = LightProtoCodec.readVarInt(_buffer);
					_topicSh.idx = _buffer.readerIndex();
					_buffer.skipBytes(_topicSh.len);
					break;
				case _TOPICS_HASH_TAG :
					_bitField0 |= _TOPICS_HASH_MASK;
					_topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
					_topicsHashBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsHashBufferLen);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandWatchTopicListSuccess clear() {
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_topicsCount = 0;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandWatchTopicListSuccess copyFrom(CommandWatchTopicListSuccess _other) {
		_cachedSize = -1;
		if (_other.hasRequestId()) {
			setRequestId(_other.requestId);
		}
		if (_other.hasWatcherId()) {
			setWatcherId(_other.watcherId);
		}
		for (int i = 0; i < _other.getTopicsCount(); i++) {
			addTopic(_other.getTopicAt(i));
		}
		if (_other.hasTopicsHash()) {
			setTopicsHash(_other.getTopicsHash());
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private io.netty.buffer.ByteBuf _parsedBuffer;

}
