/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.core.MediaType;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget adminClusters;

    public ClustersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminClusters = web.path("/admin/v2/clusters");
    }

    @Override
    public List<String> getClusters() throws PulsarAdminException {
        return (List)this.sync(this::getClustersAsync);
    }

    @Override
    public CompletableFuture<List<String>> getClustersAsync() {
        WebTarget path = this.adminClusters;
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        return (ClusterData)this.sync(() -> this.getClusterAsync(cluster));
    }

    @Override
    public CompletableFuture<ClusterData> getClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<ClusterDataImpl>(){}).thenApply(clusterData -> clusterData);
    }

    @Override
    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.createClusterAsync(cluster, clusterData));
    }

    @Override
    public CompletableFuture<Void> createClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPutRequest(path, Entity.entity((ClusterDataImpl)clusterData, "application/json"));
    }

    @Override
    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.updateClusterAsync(cluster, clusterData));
    }

    @Override
    public CompletableFuture<Void> updateClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPostRequest(path, Entity.entity((ClusterDataImpl)clusterData, MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void updatePeerClusterNames(String cluster, LinkedHashSet<String> peerClusterNames) throws PulsarAdminException {
        this.sync(() -> this.updatePeerClusterNamesAsync(cluster, peerClusterNames));
    }

    @Override
    public CompletableFuture<Void> updatePeerClusterNamesAsync(String cluster, LinkedHashSet<String> peerClusterNames) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncPostRequest(path, Entity.entity(peerClusterNames, "application/json"));
    }

    @Override
    public void updateClusterMigration(String cluster, boolean isMigrated, ClusterData.ClusterUrl clusterUrl) throws PulsarAdminException {
        this.sync(() -> this.updateClusterMigrationAsync(cluster, isMigrated, clusterUrl));
    }

    @Override
    public CompletableFuture<Void> updateClusterMigrationAsync(String cluster, boolean isMigrated, ClusterData.ClusterUrl clusterUrl) {
        WebTarget path = this.adminClusters.path(cluster).path("migrate").queryParam("migrated", isMigrated);
        return this.asyncPostRequest(path, Entity.entity(clusterUrl, "application/json"));
    }

    @Override
    public Set<String> getPeerClusterNames(String cluster) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getPeerClusterNamesAsync(cluster));
    }

    @Override
    public CompletableFuture<Set<String>> getPeerClusterNamesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Set<String>>(){});
    }

    @Override
    public void deleteCluster(String cluster) throws PulsarAdminException {
        this.sync(() -> this.deleteClusterAsync(cluster));
    }

    @Override
    public CompletableFuture<Void> deleteClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getNamespaceIsolationPoliciesAsync(cluster));
    }

    @Override
    public CompletableFuture<Map<String, NamespaceIsolationData>> getNamespaceIsolationPoliciesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, NamespaceIsolationDataImpl>>(){}).thenApply(HashMap::new);
    }

    @Override
    public List<BrokerNamespaceIsolationData> getBrokersWithNamespaceIsolationPolicy(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getBrokersWithNamespaceIsolationPolicyAsync(cluster));
    }

    @Override
    public CompletableFuture<List<BrokerNamespaceIsolationData>> getBrokersWithNamespaceIsolationPolicyAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<BrokerNamespaceIsolationDataImpl>>(){}).thenApply(ArrayList::new);
    }

    @Override
    public BrokerNamespaceIsolationData getBrokerWithNamespaceIsolationPolicy(String cluster, String broker) throws PulsarAdminException {
        return (BrokerNamespaceIsolationData)this.sync(() -> this.getBrokerWithNamespaceIsolationPolicyAsync(cluster, broker));
    }

    @Override
    public CompletableFuture<BrokerNamespaceIsolationData> getBrokerWithNamespaceIsolationPolicyAsync(String cluster, String broker) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers").path(broker);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BrokerNamespaceIsolationDataImpl>(){}).thenApply(brokerNamespaceIsolationData -> brokerNamespaceIsolationData);
    }

    @Override
    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public CompletableFuture<Void> createNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public CompletableFuture<Void> updateNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncDeleteRequest(path);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData));
    }

    private CompletableFuture<Void> setNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncPostRequest(path, Entity.entity(namespaceIsolationData, "application/json"));
    }

    @Override
    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        return (NamespaceIsolationData)this.sync(() -> this.getNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    @Override
    public CompletableFuture<NamespaceIsolationData> getNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<NamespaceIsolationDataImpl>(){}).thenApply(namespaceIsolationData -> namespaceIsolationData);
    }

    @Override
    public void createFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public CompletableFuture<Void> createFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    @Override
    public void updateFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    @Override
    public CompletableFuture<Void> updateFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    @Override
    public void deleteFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        this.sync(() -> this.deleteFailureDomainAsync(cluster, domainName));
    }

    @Override
    public CompletableFuture<Void> deleteFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, FailureDomain> getFailureDomains(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getFailureDomainsAsync(cluster));
    }

    @Override
    public CompletableFuture<Map<String, FailureDomain>> getFailureDomainsAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, FailureDomainImpl>>(){}).thenApply(HashMap::new);
    }

    @Override
    public FailureDomain getFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        return (FailureDomain)this.sync(() -> this.getFailureDomainAsync(cluster, domainName));
    }

    @Override
    public CompletableFuture<FailureDomain> getFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<FailureDomainImpl>(){}).thenApply(failureDomain -> failureDomain);
    }

    private void setDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.sync(() -> this.setDomainAsync(cluster, domainName, domain));
    }

    private CompletableFuture<Void> setDomainAsync(String cluster, String domainName, FailureDomain domain) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncPostRequest(path, Entity.entity((FailureDomainImpl)domain, "application/json"));
    }
}

