/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInfo;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckInternalStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.stats.PositionInPendingAckStats;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class TransactionsImpl
extends BaseResource
implements Transactions {
    private final WebTarget adminV3Transactions;

    public TransactionsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminV3Transactions = web.path("/admin/v3/transactions");
    }

    @Override
    public List<TransactionCoordinatorInfo> listTransactionCoordinators() throws PulsarAdminException {
        return (List)this.sync(() -> this.listTransactionCoordinatorsAsync());
    }

    @Override
    public CompletableFuture<List<TransactionCoordinatorInfo>> listTransactionCoordinatorsAsync() {
        WebTarget path = this.adminV3Transactions.path("coordinators");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<TransactionCoordinatorInfo>>(){});
    }

    @Override
    public CompletableFuture<TransactionCoordinatorStats> getCoordinatorStatsByIdAsync(int coordinatorId) {
        WebTarget path = this.adminV3Transactions.path("coordinatorStats");
        path = path.queryParam("coordinatorId", coordinatorId);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionCoordinatorStats>(){});
    }

    @Override
    public TransactionCoordinatorStats getCoordinatorStatsById(int coordinatorId) throws PulsarAdminException {
        return (TransactionCoordinatorStats)this.sync(() -> this.getCoordinatorStatsByIdAsync(coordinatorId));
    }

    @Override
    public CompletableFuture<Map<Integer, TransactionCoordinatorStats>> getCoordinatorStatsAsync() {
        WebTarget path = this.adminV3Transactions.path("coordinatorStats");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<Integer, TransactionCoordinatorStats>>(){});
    }

    @Override
    public Map<Integer, TransactionCoordinatorStats> getCoordinatorStats() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getCoordinatorStatsAsync());
    }

    @Override
    public CompletableFuture<TransactionInBufferStats> getTransactionInBufferStatsAsync(TxnID txnID, String topic) {
        TopicName topicName = TopicName.get(topic);
        WebTarget path = this.adminV3Transactions.path("transactionInBufferStats");
        path = path.path(topicName.getRestPath(false));
        path = path.path(txnID.getMostSigBits() + "");
        path = path.path(txnID.getLeastSigBits() + "");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionInBufferStats>(){});
    }

    @Override
    public TransactionInBufferStats getTransactionInBufferStats(TxnID txnID, String topic) throws PulsarAdminException {
        return (TransactionInBufferStats)this.sync(() -> this.getTransactionInBufferStatsAsync(txnID, topic));
    }

    @Override
    public CompletableFuture<TransactionInPendingAckStats> getTransactionInPendingAckStatsAsync(TxnID txnID, String topic, String subName) {
        WebTarget path = this.adminV3Transactions.path("transactionInPendingAckStats");
        path = path.path(TopicName.get(topic).getRestPath(false));
        path = path.path(subName);
        path = path.path(txnID.getMostSigBits() + "");
        path = path.path(txnID.getLeastSigBits() + "");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionInPendingAckStats>(){});
    }

    @Override
    public TransactionInPendingAckStats getTransactionInPendingAckStats(TxnID txnID, String topic, String subName) throws PulsarAdminException {
        return (TransactionInPendingAckStats)this.sync(() -> this.getTransactionInPendingAckStatsAsync(txnID, topic, subName));
    }

    @Override
    public CompletableFuture<TransactionMetadata> getTransactionMetadataAsync(TxnID txnID) {
        WebTarget path = this.adminV3Transactions.path("transactionMetadata");
        path = path.path(txnID.getMostSigBits() + "");
        path = path.path(txnID.getLeastSigBits() + "");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionMetadata>(){});
    }

    @Override
    public TransactionMetadata getTransactionMetadata(TxnID txnID) throws PulsarAdminException {
        return (TransactionMetadata)this.sync(() -> this.getTransactionMetadataAsync(txnID));
    }

    @Override
    public CompletableFuture<TransactionBufferStats> getTransactionBufferStatsAsync(String topic, boolean lowWaterMarks) {
        WebTarget path = this.adminV3Transactions.path("transactionBufferStats");
        path = path.path(TopicName.get(topic).getRestPath(false));
        path = path.queryParam("lowWaterMarks", lowWaterMarks);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionBufferStats>(){});
    }

    @Override
    public TransactionBufferStats getTransactionBufferStats(String topic, boolean lowWaterMarks) throws PulsarAdminException {
        return (TransactionBufferStats)this.sync(() -> this.getTransactionBufferStatsAsync(topic, lowWaterMarks));
    }

    @Override
    public CompletableFuture<TransactionPendingAckStats> getPendingAckStatsAsync(String topic, String subName, boolean lowWaterMarks) {
        WebTarget path = this.adminV3Transactions.path("pendingAckStats");
        path = path.path(TopicName.get(topic).getRestPath(false));
        path = path.path(subName);
        path = path.queryParam("lowWaterMarks", lowWaterMarks);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionPendingAckStats>(){});
    }

    @Override
    public TransactionPendingAckStats getPendingAckStats(String topic, String subName, boolean lowWaterMarks) throws PulsarAdminException {
        return (TransactionPendingAckStats)this.sync(() -> this.getPendingAckStatsAsync(topic, subName, lowWaterMarks));
    }

    @Override
    public CompletableFuture<Map<String, TransactionMetadata>> getSlowTransactionsByCoordinatorIdAsync(Integer coordinatorId, long timeout, TimeUnit timeUnit) {
        WebTarget path = this.adminV3Transactions.path("slowTransactions");
        path = path.path(timeUnit.toMillis(timeout) + "");
        if (coordinatorId != null) {
            path = path.queryParam("coordinatorId", coordinatorId);
        }
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, TransactionMetadata>>(){});
    }

    @Override
    public Map<String, TransactionMetadata> getSlowTransactionsByCoordinatorId(Integer coordinatorId, long timeout, TimeUnit timeUnit) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getSlowTransactionsByCoordinatorIdAsync(coordinatorId, timeout, timeUnit));
    }

    @Override
    public CompletableFuture<Map<String, TransactionMetadata>> getSlowTransactionsAsync(long timeout, TimeUnit timeUnit) {
        return this.getSlowTransactionsByCoordinatorIdAsync(null, timeout, timeUnit);
    }

    @Override
    public Map<String, TransactionMetadata> getSlowTransactions(long timeout, TimeUnit timeUnit) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getSlowTransactionsAsync(timeout, timeUnit));
    }

    @Override
    public CompletableFuture<TransactionCoordinatorInternalStats> getCoordinatorInternalStatsAsync(int coordinatorId, boolean metadata) {
        WebTarget path = this.adminV3Transactions.path("coordinatorInternalStats");
        path = path.path(coordinatorId + "");
        path = path.queryParam("metadata", metadata);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionCoordinatorInternalStats>(){});
    }

    @Override
    public TransactionCoordinatorInternalStats getCoordinatorInternalStats(int coordinatorId, boolean metadata) throws PulsarAdminException {
        return (TransactionCoordinatorInternalStats)this.sync(() -> this.getCoordinatorInternalStatsAsync(coordinatorId, metadata));
    }

    @Override
    public CompletableFuture<TransactionPendingAckInternalStats> getPendingAckInternalStatsAsync(String topic, String subName, boolean metadata) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.adminV3Transactions.path("pendingAckInternalStats");
        path = path.path(tn.getRestPath(false));
        path = path.path(subName);
        path = path.queryParam("metadata", metadata);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TransactionPendingAckInternalStats>(){});
    }

    @Override
    public TransactionPendingAckInternalStats getPendingAckInternalStats(String topic, String subName, boolean metadata) throws PulsarAdminException {
        return (TransactionPendingAckInternalStats)this.sync(() -> this.getPendingAckInternalStatsAsync(topic, subName, metadata));
    }

    @Override
    public void scaleTransactionCoordinators(int replicas) throws PulsarAdminException {
        this.sync(() -> this.scaleTransactionCoordinatorsAsync(replicas));
    }

    @Override
    public CompletableFuture<Void> scaleTransactionCoordinatorsAsync(int replicas) {
        Preconditions.checkArgument(replicas > 0, "Number of transaction coordinators must be more than 0");
        WebTarget path = this.adminV3Transactions.path("transactionCoordinator");
        path = path.path("replicas");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(replicas), "application/json"));
    }

    @Override
    public CompletableFuture<PositionInPendingAckStats> getPositionStatsInPendingAckAsync(String topic, String subName, Long ledgerId, Long entryId, Integer batchIndex) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.adminV3Transactions.path("positionStatsInPendingAck");
        path = path.path(tn.getRestPath(false));
        path = path.path(subName);
        path = path.path(ledgerId.toString());
        path = path.path(entryId.toString());
        path = path.queryParam("batchIndex", batchIndex);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PositionInPendingAckStats>(){});
    }

    @Override
    public PositionInPendingAckStats getPositionStatsInPendingAck(String topic, String subName, Long ledgerId, Long entryId, Integer batchIndex) throws PulsarAdminException {
        return (PositionInPendingAckStats)this.sync(() -> this.getPositionStatsInPendingAckAsync(topic, subName, ledgerId, entryId, batchIndex));
    }
}

